/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor.action;

import at.dallermassl.josm.plugin.surveyor.GpsActionEvent;
import at.dallermassl.josm.plugin.surveyor.action.AbstractSurveyorAction;
import at.dallermassl.josm.plugin.surveyor.util.ResourceLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.Logging;

public class PlayAudioAction
extends AbstractSurveyorAction {
    private String audioSource = null;

    @Override
    public void actionPerformed(GpsActionEvent event) {
        MainApplication.worker.execute(() -> {
            try {
                BufferedInputStream in;
                AudioInputStream stream;
                AudioFormat format;
                if (this.audioSource == null) {
                    this.audioSource = this.getParameters().get(0);
                }
                if ((format = (stream = AudioSystem.getAudioInputStream(in = new BufferedInputStream(ResourceLoader.getInputStream(this.audioSource)))).getFormat()).getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                    format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                    stream = AudioSystem.getAudioInputStream(format, stream);
                }
                DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.open(stream);
                clip.start();
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e1) {
                Logging.error((Throwable)e1);
            }
        });
    }
}

