/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import at.dallermassl.josm.plugin.surveyor.GpsActionEvent;
import at.dallermassl.josm.plugin.surveyor.GpsDataSource;
import at.dallermassl.josm.plugin.surveyor.SurveyorActionDescription;
import at.dallermassl.josm.plugin.surveyor.SurveyorPlugin;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import livegps.LiveGpsData;
import org.openstreetmap.josm.spi.preferences.Config;

public class MetaAction
extends AbstractAction {
    private static final long serialVersionUID = -1523524381092575809L;
    private List<SurveyorActionDescription> actions;
    private GpsDataSource gpsDataSource;
    private long lastActionCall = 0L;
    public static final long MIN_TIME_DIFF = 500L;

    public MetaAction() {
    }

    public MetaAction(String name) {
        super(name);
    }

    public MetaAction(String name, Icon icon) {
        super(name, icon);
    }

    public List<SurveyorActionDescription> getActions() {
        return this.actions;
    }

    public void setActions(List<SurveyorActionDescription> actions) {
        this.actions = actions;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFrame frame;
        long time = System.currentTimeMillis();
        if (time - this.lastActionCall < 500L) {
            this.lastActionCall = time;
            return;
        }
        this.lastActionCall = time;
        Boolean selected = (Boolean)this.getValue("actionConstants.selected");
        selected = selected == null || selected == Boolean.FALSE ? Boolean.TRUE : Boolean.FALSE;
        this.putValue("actionConstants.selected", selected);
        LiveGpsData gpsData = this.gpsDataSource.getGpsData();
        if (gpsData != null && gpsData.isFix()) {
            double latitude = gpsData.getLatitude();
            double longitude = gpsData.getLongitude();
            GpsActionEvent gpsEvent = new GpsActionEvent(e, latitude, longitude);
            for (SurveyorActionDescription action : this.actions) {
                action.actionPerformed(gpsEvent);
            }
        } else {
            System.out.println("Surveyor: no gps data available!");
            if (Config.getPref().getBoolean("surveyor.debug")) {
                for (SurveyorActionDescription action : this.actions) {
                    action.actionPerformed(new GpsActionEvent(e, 0.0, 0.0));
                }
            }
        }
        if ((frame = SurveyorPlugin.getSurveyorFrame()) != null && frame.isVisible()) {
            frame.toFront();
        }
    }

    public void setGpsDataSource(GpsDataSource gpsDataSource) {
        this.gpsDataSource = gpsDataSource;
    }
}

