/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.personalization;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.SwingWorker;
import org.openstreetmap.josm.plugins.osmrec.container.OSMWay;
import org.openstreetmap.josm.plugins.osmrec.extractor.LanguageDetector;
import org.openstreetmap.josm.plugins.osmrec.parsers.OSMParser;
import org.openstreetmap.josm.plugins.osmrec.personalization.HistoryParser;
import org.openstreetmap.josm.plugins.osmrec.personalization.TrainByUser;

public class UserDataExtractAndTrainWorker
extends SwingWorker<Void, Void>
implements ActionListener {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final ArrayList<String> timeIntervals = new ArrayList();
    private final String username;
    private final Integer days;
    private List<OSMWay> wayList = new ArrayList<OSMWay>();
    private final boolean byArea;
    private final String inputFilePath;
    private final boolean validateFlag;
    private final double cParameterFromUser;
    private final int topK;
    private final int frequency;
    private final boolean topKIsSelected;
    private final LanguageDetector languageDetector;

    public UserDataExtractAndTrainWorker(String inputFilePath, String username, Integer days, boolean byArea, boolean validateFlag, double cParameterFromUser, int topK, int frequency, boolean topKIsSelected, LanguageDetector languageDetector) {
        this.inputFilePath = inputFilePath;
        this.username = username;
        this.days = days;
        this.byArea = byArea;
        this.validateFlag = validateFlag;
        this.cParameterFromUser = cParameterFromUser;
        this.topK = topK;
        this.frequency = frequency;
        this.topKIsSelected = topKIsSelected;
        this.languageDetector = languageDetector;
    }

    @Override
    protected Void doInBackground() throws Exception {
        System.out.println("UserDataExtractAndTrainWorker doInBackground initiating..");
        if (this.byArea) {
            this.extractByArea();
        } else {
            this.extractHistory();
        }
        TrainByUser trainByUser = new TrainByUser(this.inputFilePath, this.username, this.validateFlag, this.cParameterFromUser, this.topK, this.frequency, this.topKIsSelected, this.languageDetector, this.wayList);
        System.out.println("trainByUser executing..");
        trainByUser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    int progress = (Integer)evt.getNewValue();
                    System.out.println("progress++ from property change listener, progress: " + progress);
                    UserDataExtractAndTrainWorker.this.setProgress(progress);
                }
            }
        });
        trainByUser.doInBackground();
        this.setProgress(100);
        return null;
    }

    private void extractHistory() {
        if (this.wayList != null) {
            this.wayList.clear();
        }
        this.produceTimeIntervals(this.days);
        HistoryParser historyParser = new HistoryParser(this.username);
        for (String time : timeIntervals) {
            System.out.println("interval\n " + time);
            historyParser.historyParse(time);
        }
        this.wayList = historyParser.getWayList();
    }

    private void extractByArea() {
        System.out.println("Extracting by Area..");
        if (this.wayList != null) {
            this.wayList.clear();
        }
        OSMParser osmParser = new OSMParser(this.inputFilePath);
        osmParser.parseDocument();
        List<OSMWay> completeWayList = osmParser.getWayList();
        System.out.println("completeWayList size: " + completeWayList.size());
        System.out.println("populating wayList with edits from username: " + this.username);
        for (OSMWay way : completeWayList) {
            if (!way.getUser().equals(this.username)) continue;
            System.out.println("found user edit!");
            this.wayList.add(way);
        }
        System.out.println("weeding wayList by user done.");
        if (this.wayList.isEmpty()) {
            System.out.println("User has not edited this Area. Try \"By time\" option.");
        } else {
            System.out.println("User has edited " + this.wayList.size() + " OSM entities in this area.");
        }
    }

    private void produceTimeIntervals(Integer days) {
        String startingTimeString;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date currentDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        String currentTimeString = sdf.format(currentDate);
        cal.add(5, -days.intValue());
        Date startingTime = cal.getTime();
        String nextIntervalTime = startingTimeString = sdf.format(startingTime);
        do {
            cal.add(5, 10);
            Date intervalTime = cal.getTime();
            String intervalTimeString = sdf.format(intervalTime);
            String timeOsmApiArgument = nextIntervalTime + "," + intervalTimeString;
            if (cal.getTime().after(currentDate)) {
                timeOsmApiArgument = nextIntervalTime + "," + currentTimeString;
                timeIntervals.add(timeOsmApiArgument);
                System.out.println(timeOsmApiArgument);
                break;
            }
            timeIntervals.add(timeOsmApiArgument);
            nextIntervalTime = intervalTimeString;
            System.out.println(" ti: " + timeOsmApiArgument);
        } while (cal.getTime().before(currentDate));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }
}

