/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.tofix.TofixDialog;

public class Download {
    public static void download(Bounds bounds, final Long osm_obj_id, double downloadSize) {
        DownloadOsmTask task = new DownloadOsmTask();
        ProgressMonitor monitor = null;
        if (bounds.getArea() == 0.0) {
            bounds = new Bounds(new BBox(bounds.getCenter().getX(), bounds.getCenter().getY(), downloadSize).toRectangle());
        } else if (bounds.getArea() < 10.0) {
            bounds.extend(bounds.getMax().lat() + 1.0E-4, bounds.getMax().lon() + 1.0E-4);
            bounds.extend(bounds.getMin().lat() - 1.0E-4, bounds.getMin().lon() - 1.0E-4);
        } else if (bounds.getArea() > 10.0) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), ExpressionFactory.Functions.tr((String[])new String[]{"This big area cannot be downloaded!"}), ExpressionFactory.Functions.tr((String[])new String[]{"Warning"}), 2);
            return;
        }
        final Future future = task.download(true, bounds, monitor);
        if (osm_obj_id != null) {
            Runnable runAfterTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (osm_obj_id != 0L) {
                            future.get();
                            if (future.isDone()) {
                                DataSet dataset = MainApplication.getLayerManager().getEditLayer().data;
                                Node node = new Node(osm_obj_id.longValue());
                                Relation relation = new Relation(osm_obj_id.longValue());
                                Way way = new Way(osm_obj_id.longValue());
                                ArrayList<Object> selection = new ArrayList<Object>();
                                if (dataset.allPrimitives().contains(node)) {
                                    selection.add(node);
                                    dataset.setSelected(selection);
                                } else if (dataset.allPrimitives().contains(way)) {
                                    selection.add(way);
                                    dataset.setSelected(selection);
                                } else if (dataset.allPrimitives().contains(relation)) {
                                    selection.add(relation);
                                    dataset.setSelected(selection);
                                }
                                if (!selection.isEmpty()) {
                                    AutoScaleAction.autoScale((String)"selection");
                                }
                            }
                        }
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        Logger.getLogger(TofixDialog.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            MainApplication.worker.submit(runAfterTask);
        }
    }
}

