/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.utilities.ImageUtilities;

public class RangeByte
extends Range {
    public static RangeByte FULL_RANGE = new RangeByte(0, true, -1, true);
    private final int minValue;
    private final int maxValue;
    private final boolean isPoint;

    RangeByte(byte minValue, boolean minIncluded, byte maxValue, boolean maxIncluded) {
        super(minIncluded, maxIncluded);
        int minValueInt = minValue & 0xFF;
        int maxValueInt = maxValue & 0xFF;
        if (minValueInt < maxValueInt) {
            this.minValue = minValueInt;
            this.maxValue = maxValueInt;
            this.isPoint = false;
        } else if (minValueInt > maxValueInt) {
            this.minValue = maxValueInt;
            this.maxValue = minValueInt;
            this.isPoint = false;
        } else {
            this.minValue = minValueInt;
            this.maxValue = minValueInt;
            this.isPoint = true;
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.setMinIncluded(true);
            this.setMaxIncluded(true);
        }
    }

    @Override
    public boolean contains(byte value) {
        boolean lower;
        int valueI = value & 0xFF;
        if (this.isPoint) {
            return this.minValue == valueI;
        }
        if (this.isMinIncluded()) {
            lower = valueI < this.minValue;
        } else {
            boolean bl = lower = valueI <= this.minValue;
        }
        boolean upper = this.isMaxIncluded() ? valueI > this.maxValue : valueI >= this.maxValue;
        return !lower && !upper;
    }

    @Override
    public Range.DataType getDataType() {
        return Range.DataType.BYTE;
    }

    @Override
    public boolean isPoint() {
        return this.isPoint;
    }

    @Override
    public Number getMax() {
        return this.maxValue;
    }

    @Override
    public Number getMax(boolean isMaxIncluded) {
        int value = this.maxValue;
        if (isMaxIncluded != this.isMaxIncluded()) {
            value = (int)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMaxIncluded ? -1 : 1);
        }
        return value;
    }

    @Override
    public Number getMin(boolean isMinIncluded) {
        int value = this.minValue;
        if (isMinIncluded != this.isMinIncluded()) {
            value = (int)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMinIncluded ? -1 : 1);
        }
        return value;
    }

    @Override
    public Number getMin() {
        return this.minValue;
    }

    @Override
    public Range union(Range other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        int min2 = other.getMin().intValue();
        int max2 = other.getMax().intValue();
        int finalMin = this.minValue;
        int finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (min2 < this.minValue) {
            finalMin = min2;
            minIncluded = other.isMinIncluded();
        } else if (min2 == this.minValue) {
            minIncluded |= other.isMinIncluded();
        }
        if (max2 > this.maxValue) {
            finalMax = max2;
            maxIncluded = other.isMaxIncluded();
        } else if (max2 == this.maxValue) {
            maxIncluded |= other.isMaxIncluded();
        }
        return new RangeByte((byte)finalMin, minIncluded, (byte)finalMax, maxIncluded);
    }

    @Override
    public Range intersection(Range other) {
        if (other.getDataType() == this.getDataType()) {
            if (other.contains(this)) {
                return this;
            }
            if (this.contains(other)) {
                return other;
            }
        }
        int minOther = other.getMin().intValue();
        int maxOther = other.getMax().intValue();
        int finalMin = this.minValue;
        int finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (minOther > this.minValue) {
            finalMin = minOther;
            minIncluded = other.isMinIncluded();
        } else if (minOther == this.minValue) {
            minIncluded &= other.isMinIncluded();
        }
        if (maxOther < this.maxValue) {
            finalMax = maxOther;
            maxIncluded = other.isMaxIncluded();
        } else if (maxOther == this.maxValue) {
            maxIncluded &= other.isMaxIncluded();
        }
        if (finalMax < finalMin || finalMax == finalMin && !minIncluded && !maxIncluded) {
            return null;
        }
        return new RangeByte((byte)finalMin, minIncluded, (byte)finalMax, maxIncluded);
    }
}

