/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.plugins.changeset.Changeset;
import org.openstreetmap.josm.plugins.changeset.util.CellRenderer;
import org.openstreetmap.josm.plugins.changeset.util.ChangesetBeen;
import org.openstreetmap.josm.plugins.changeset.util.ChangesetController;
import org.openstreetmap.josm.plugins.changeset.util.Config;
import org.openstreetmap.josm.plugins.changeset.util.DataSetChangesetBuilder;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public final class ChangesetDialog
extends ToggleDialog
implements ActionListener {
    private MapView mv;
    private final JPanel jContentPanel;
    private final JPanel jPanelProjects;
    private final JPanel jPanelOptions;
    private final JButton jButtonGetChangesets;
    private final JButton jButtonNext;
    private final JButton jButtonprevious;
    private final SideButton displayChangesetButton;
    private final SideButton OpenChangesetweb;
    private final JTextField jTextFieldChangesetId;
    private final ChangesetController changesetController;
    Changeset Changeset;
    private final ListCellRenderer renderer;
    private final JComboBox jComboBox;
    private boolean flag;

    public ChangesetDialog() {
        super(ExpressionFactory.Functions.tr((String[])new String[]{"Changeset viewer"}), "changeset", ExpressionFactory.Functions.tr((String[])new String[]{"Open changeset Viewer window."}), Shortcut.registerShortcut((String)"Tool:changeset-viewer", (String)ExpressionFactory.Functions.tr((String[])new String[]{"Toggle: {0}", ExpressionFactory.Functions.tr((String[])new String[]{"Tool:changeset-Viewer"})}), (int)84, (int)5010), 120);
        this.mv = MainApplication.getMap().mapView;
        this.jContentPanel = new JPanel(new GridLayout(1, 1));
        this.jPanelProjects = new JPanel(new GridLayout(4, 1));
        this.jPanelOptions = new JPanel(new GridLayout(1, 2));
        this.jButtonGetChangesets = new JButton(ExpressionFactory.Functions.tr((String[])new String[]{"Get changeset in the area"}));
        this.jButtonNext = new JButton(ExpressionFactory.Functions.tr((String[])new String[]{"Next ->"}));
        this.jButtonprevious = new JButton(ExpressionFactory.Functions.tr((String[])new String[]{"<- Previous"}));
        this.changesetController = new ChangesetController();
        this.Changeset = new Changeset();
        this.renderer = new CellRenderer();
        this.jComboBox = new JComboBox();
        this.flag = true;
        this.jPanelProjects.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanelProjects.add(this.jButtonGetChangesets);
        this.jButtonprevious.setEnabled(false);
        this.jButtonNext.setEnabled(false);
        this.jButtonGetChangesets.addActionListener(e -> {
            this.flag = false;
            Config.setPAGE(1);
            Bounds bounds = this.mv.getRealBounds();
            String bbox = String.valueOf(bounds.getMinLon()) + "," + String.valueOf(bounds.getMinLat()) + "," + String.valueOf(bounds.getMaxLon()) + "," + String.valueOf(bounds.getMaxLat());
            Config.setBBOX(bbox);
            this.getChangesets();
            this.jButtonNext.setEnabled(true);
        });
        this.jButtonprevious.addActionListener(e -> {
            this.flag = false;
            if (Config.getPAGE() > 1) {
                Config.setPAGE(Config.getPAGE() - 1);
                this.getChangesets();
            }
        });
        this.jButtonNext.addActionListener(e -> {
            this.jButtonprevious.setEnabled(true);
            this.flag = false;
            Config.setPAGE(Config.getPAGE() + 1);
            this.getChangesets();
        });
        this.jComboBox.addActionListener(this);
        this.jPanelProjects.add(this.jComboBox);
        this.jPanelOptions.add(this.jButtonprevious);
        this.jPanelOptions.add(this.jButtonNext);
        this.jPanelProjects.add(this.jPanelOptions);
        this.jTextFieldChangesetId = new JTextField("55006771");
        this.jPanelProjects.add(this.jTextFieldChangesetId);
        this.jContentPanel.add(this.jPanelProjects);
        this.displayChangesetButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", ExpressionFactory.Functions.tr((String[])new String[]{"Display changeset"}));
                new ImageProvider("mapmode", "getchangeset").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", ExpressionFactory.Functions.tr((String[])new String[]{"Display changeset"}));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChangesetDialog.this.jTextFieldChangesetId.getText().isEmpty()) {
                    ChangesetDialog.this.printMap(ChangesetDialog.this.jTextFieldChangesetId.getText());
                } else {
                    JOptionPane.showMessageDialog(Main.parent, ExpressionFactory.Functions.tr((String[])new String[]{"Fill a changeset id!"}));
                }
            }
        });
        this.OpenChangesetweb = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", ExpressionFactory.Functions.tr((String[])new String[]{"Open in OSM"}));
                new ImageProvider("mapmode", "getchangeset").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", ExpressionFactory.Functions.tr((String[])new String[]{"Open in OSM"}));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChangesetDialog.this.jTextFieldChangesetId.getText().isEmpty()) {
                    OpenBrowser.displayUrl((String)("https://www.openstreetmap.org/changeset/" + ChangesetDialog.this.jTextFieldChangesetId.getText()));
                } else {
                    JOptionPane.showMessageDialog(Main.parent, ExpressionFactory.Functions.tr((String[])new String[]{"Fill a changeset id!"}));
                }
            }
        });
        this.createLayout(this.jContentPanel, false, Arrays.asList(this.displayChangesetButton, this.OpenChangesetweb));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ChangesetBeen ch = (ChangesetBeen)this.jComboBox.getSelectedItem();
        if (ch != null && this.flag) {
            this.jTextFieldChangesetId.setText(String.valueOf(ch.getChangesetId()));
            this.printMap(String.valueOf(ch.getChangesetId()));
        }
        this.flag = true;
    }

    private void getChangesets() {
        Object[] elements;
        this.jComboBox.removeAllItems();
        for (Object element : elements = this.changesetController.getListChangeset()) {
            this.jComboBox.addItem(element);
        }
        this.jComboBox.setRenderer(this.renderer);
    }

    public void printMap(String ChangesetId) {
        DataSetChangesetBuilder.BoundedChangesetDataSet boundedDataSet = this.changesetController.getChangeset(ChangesetId);
        if (boundedDataSet == null) {
            JOptionPane.showMessageDialog(Main.parent, ExpressionFactory.Functions.tr((String[])new String[]{"Check the right changeset Id, if it is ok, maybe the changeset was not processed yet, try again in few minutes!"}));
        } else {
            this.Changeset.work(boundedDataSet, ChangesetId);
        }
    }
}

