/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.io.download.StreetsideSquareDownloadRunnable;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;

public final class StreetsideDownloader {
    static final Logger logger = Logger.getLogger(StreetsideDownloader.class);
    private static final double MAX_AREA = StreetsideProperties.MAX_DOWNLOAD_AREA.get();
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(3, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), new ThreadPoolExecutor.DiscardPolicy());
    private static boolean stoppedDownload;

    private StreetsideDownloader() {
    }

    public static void getImages(LatLon minLatLon, LatLon maxLatLon) {
        if (minLatLon == null || maxLatLon == null) {
            throw new IllegalArgumentException();
        }
        StreetsideDownloader.getImages(new Bounds(minLatLon, maxLatLon));
    }

    public static void getImages(Bounds bounds) {
        StreetsideDownloader.run(new StreetsideSquareDownloadRunnable(bounds));
    }

    public static DOWNLOAD_MODE getMode() {
        return DOWNLOAD_MODE.fromPrefId(StreetsideProperties.DOWNLOAD_MODE.get());
    }

    private static void run(Runnable t) {
        executor.execute(t);
    }

    public static void downloadVisibleArea() {
        Bounds view = MainApplication.getMap().mapView.getRealBounds();
        if (StreetsideDownloader.isAreaTooBig(view.getArea())) {
            return;
        }
        if (StreetsideDownloader.isViewDownloaded(view)) {
            return;
        }
        StreetsideLayer.getInstance().getData().getBounds().add(view);
        StreetsideDownloader.getImages(view);
    }

    private static boolean isViewDownloaded(Bounds view) {
        int j;
        int i;
        int n = 15;
        boolean[][] inside = new boolean[n][n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (!StreetsideDownloader.isInBounds(new LatLon(view.getMinLat() + (view.getMaxLat() - view.getMinLat()) * ((double)i / (double)n), view.getMinLon() + (view.getMaxLon() - view.getMinLon()) * ((double)j / (double)n)))) continue;
                inside[i][j] = true;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                if (inside[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInBounds(LatLon latlon) {
        return StreetsideLayer.getInstance().getData().getBounds().parallelStream().anyMatch(b -> b.contains(latlon));
    }

    public static void downloadOSMArea() {
        if (MainApplication.getLayerManager().getEditLayer() == null) {
            return;
        }
        if (StreetsideDownloader.isAreaTooBig(MainApplication.getLayerManager().getEditLayer().data.getDataSourceBounds().parallelStream().map(Bounds::getArea).reduce(0.0, Double::sum))) {
            return;
        }
        MainApplication.getLayerManager().getEditLayer().data.getDataSourceBounds().stream().filter(bounds -> !StreetsideLayer.getInstance().getData().getBounds().contains(bounds)).forEach(bounds -> {
            StreetsideLayer.getInstance().getData().getBounds().add((Bounds)bounds);
            StreetsideDownloader.getImages(bounds.getMin(), bounds.getMax());
        });
    }

    private static boolean isAreaTooBig(double area) {
        boolean tooBig;
        boolean bl = tooBig = area > MAX_AREA;
        if (!stoppedDownload && tooBig) {
            new Notification(I18n.tr((String)"The Streetside layer has stopped downloading images, because the requested area is too big!", (Object[])new Object[0]) + (StreetsideDownloader.getMode() == DOWNLOAD_MODE.VISIBLE_AREA ? "\n" + I18n.tr((String)"To solve this problem, you could zoom in and load a smaller area of the map.", (Object[])new Object[0]) : (StreetsideDownloader.getMode() == DOWNLOAD_MODE.OSM_AREA ? "\n" + I18n.tr((String)"To solve this problem, you could switch to download mode ''{0}'' and load Streetside images for a smaller portion of the map.", (Object[])new Object[]{DOWNLOAD_MODE.MANUAL_ONLY}) : ""))).setIcon((Icon)StreetsidePlugin.LOGO.get()).setDuration(Notification.TIME_LONG).show();
        }
        if (stoppedDownload && !tooBig) {
            new Notification("The Streetside layer now continues to download images\u2026").setIcon((Icon)StreetsidePlugin.LOGO.get()).show();
        }
        stoppedDownload = tooBig;
        return tooBig;
    }

    public static void stopAll() {
        executor.shutdownNow();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error(e);
        }
        executor = new ThreadPoolExecutor(3, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), new ThreadPoolExecutor.DiscardPolicy());
    }

    public static enum DOWNLOAD_MODE {
        VISIBLE_AREA("visibleArea", I18n.tr((String)"everything in the visible area", (Object[])new Object[0])),
        OSM_AREA("osmArea", I18n.tr((String)"areas with downloaded OSM-data", (Object[])new Object[0])),
        MANUAL_ONLY("manualOnly", I18n.tr((String)"only when manually requested", (Object[])new Object[0]));

        public static final DOWNLOAD_MODE DEFAULT;
        private final String prefId;
        private final String label;

        private DOWNLOAD_MODE(String prefId, String label) {
            this.prefId = prefId;
            this.label = label;
        }

        public String getPrefId() {
            return this.prefId;
        }

        public String getLabel() {
            return this.label;
        }

        public static DOWNLOAD_MODE fromPrefId(String prefId) {
            for (DOWNLOAD_MODE mode : DOWNLOAD_MODE.values()) {
                if (!mode.getPrefId().equals(prefId)) continue;
                return mode;
            }
            return DEFAULT;
        }

        public static DOWNLOAD_MODE fromLabel(String label) {
            for (DOWNLOAD_MODE mode : DOWNLOAD_MODE.values()) {
                if (!mode.getLabel().equals(label)) continue;
                return mode;
            }
            return DEFAULT;
        }

        static {
            DEFAULT = OSM_AREA;
        }
    }
}

