/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.history.commands;

import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideCommand;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideExecutableCommand;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;
import org.openstreetmap.josm.tools.I18n;

public class CommandUnjoin
extends StreetsideExecutableCommand {
    private final StreetsideAbstractImage a;
    private final StreetsideAbstractImage b;

    public CommandUnjoin(List<StreetsideAbstractImage> images) {
        super(new ConcurrentSkipListSet<StreetsideAbstractImage>(images));
        this.a = images.get(0);
        this.b = images.get(1);
        if (images.size() != 2) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        StreetsideUtils.join(this.a, this.b);
    }

    @Override
    public void redo() {
        StreetsideUtils.unjoin(this.a, this.b);
    }

    @Override
    public void sum(StreetsideCommand command) {
    }

    @Override
    public String toString() {
        return I18n.tr((String)"2 images unjoined", (Object[])new Object[0]);
    }
}

