/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.SelectableLabel;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.StreetsideButton;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ImageInfoPanel;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideColorScheme;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageInfoHelpPopup
extends JPopupMenu {
    private static final long serialVersionUID = -1721594904273820586L;
    static final Logger logger = Logger.getLogger(ImageInfoHelpPopup.class);
    private final Component invokerComp;
    private boolean alreadyDisplayed;

    public ImageInfoHelpPopup(Component invoker) {
        this.invokerComp = invoker;
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel topBar = new JPanel();
        topBar.add(new JLabel(ImageProvider.get((String)"streetside-logo-white")));
        topBar.setBackground(StreetsideColorScheme.TOOLBAR_DARK_GREY);
        this.add((Component)topBar, "North");
        JTextPane mainText = new JTextPane();
        mainText.setContentType("text/html");
        mainText.setFont(SelectableLabel.DEFAULT_FONT);
        mainText.setText("<html><div style='width:250px'>Welcome to the Microsoft Streetside JOSM Plugin. To view the vector bubbles for the 360 degree imagery, select Imagery->Streetside from the JOSM menu.<br><br>Once the blue bubbles appear on the map, click on a vector bubble and undock/maximize the 360 viewer to view the imagery.</div></html>");
        this.add((Component)mainText, "Center");
        JPanel bottomBar = new JPanel();
        bottomBar.setBackground(new Color(0xFFFFFF, true));
        StreetsideButton infoButton = new StreetsideButton(ImageInfoPanel.getInstance().getToggleAction());
        infoButton.addActionListener(e -> this.setVisible(false));
        bottomBar.add(infoButton);
        StreetsideButton closeBtn = new StreetsideButton(new AbstractAction(){
            private static final long serialVersionUID = 2853315308169651854L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageInfoHelpPopup.this.setVisible(false);
                StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.put(Integer.valueOf(0));
            }
        });
        closeBtn.setText(I18n.tr((String)"I got it, close this.", (Object[])new Object[0]));
        bottomBar.add(closeBtn);
        this.add((Component)bottomBar, "South");
        this.setBackground(Color.WHITE);
    }

    public boolean showPopup() {
        if (!this.alreadyDisplayed && this.invokerComp.isShowing()) {
            try {
                this.show(this.invokerComp, this.invokerComp.getWidth(), 0);
                this.alreadyDisplayed = true;
                return true;
            }
            catch (IllegalComponentStateException e) {
                logger.warn(I18n.tr((String)"Could not show ImageInfoHelpPopup, because probably the invoker component has disappeared from screen.", (Object[])new Object[]{e}));
            }
        }
        return false;
    }
}

