/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.actions;

import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideData;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.cache.CacheUtils;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;

public class WalkThread
extends Thread
implements StreetsideDataListener {
    private final int interval;
    private final StreetsideData data;
    private boolean end;
    private final boolean waitForFullQuality;
    private final boolean followSelected;
    private final boolean goForward;
    private BufferedImage lastImage;
    private volatile boolean paused;
    static final Logger logger = Logger.getLogger(WalkThread.class);

    public WalkThread(int interval, boolean waitForPicture, boolean followSelected, boolean goForward) {
        this.interval = interval;
        this.waitForFullQuality = waitForPicture;
        this.followSelected = followSelected;
        this.goForward = goForward;
        this.data = StreetsideLayer.getInstance().getData();
        this.data.addListener(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.end && this.data.getSelectedImage().next() != null) {
                StreetsideAbstractImage image = this.data.getSelectedImage();
                if (image != null && image.next() instanceof StreetsideImage) {
                    WalkThread.preDownloadImages((StreetsideImage)image.next(), 10, CacheUtils.PICTURE.THUMBNAIL);
                    if (StreetsideProperties.PREDOWNLOAD_CUBEMAPS.get().booleanValue()) {
                        this.preDownloadCubemaps((StreetsideImage)image.next(), 10);
                    }
                    if (this.waitForFullQuality) {
                        StreetsideAbstractImage currentImage = image.next();
                        WalkThread.preDownloadImages((StreetsideImage)currentImage, 3, CacheUtils.PICTURE.FULL_IMAGE);
                    }
                }
                try {
                    BufferedImage displayImage = StreetsideMainDialog.getInstance().getStreetsideImageDisplay().getImage();
                    if (this.waitForFullQuality && image instanceof StreetsideImage) {
                        while (displayImage == this.lastImage || displayImage == null || displayImage.getWidth() < 2048) {
                            Thread.sleep(100L);
                        }
                    } else {
                        while (displayImage == this.lastImage || displayImage == null || displayImage.getWidth() < 320) {
                            Thread.sleep(100L);
                        }
                    }
                    while (this.paused) {
                        Thread.sleep(100L);
                    }
                    this.wait(this.interval);
                    while (this.paused) {
                        Thread.sleep(100L);
                    }
                    this.lastImage = StreetsideMainDialog.getInstance().getStreetsideImageDisplay().getImage();
                    if (this.goForward) {
                        this.data.selectNext(this.followSelected);
                        continue;
                    }
                    this.data.selectPrevious(this.followSelected);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
        catch (NullPointerException e) {
            if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
                logger.debug(MessageFormat.format("Exception thrown in WalkThread: {0}", e.getMessage()));
                e.printStackTrace();
            }
            return;
        }
        this.end();
    }

    private void preDownloadCubemaps(StreetsideImage startImage, int n) {
        if (n >= 1 && startImage != null) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 4; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        CacheUtils.downloadPicture(startImage, CacheUtils.PICTURE.CUBEMAP);
                        if (!(startImage.next() instanceof StreetsideImage) || n < 2) continue;
                        this.preDownloadCubemaps((StreetsideImage)startImage.next(), n - 1);
                    }
                }
            }
        }
    }

    private static void preDownloadImages(StreetsideImage startImage, int n, CacheUtils.PICTURE type) {
        if (n >= 1 && startImage != null) {
            CacheUtils.downloadPicture(startImage, type);
            if (startImage.next() instanceof StreetsideImage && n >= 2) {
                WalkThread.preDownloadImages((StreetsideImage)startImage.next(), n - 1, type);
            }
        }
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        if (newImage != oldImage.next()) {
            this.end();
            this.interrupt();
        }
    }

    public void play() {
        this.paused = false;
    }

    public void pause() {
        this.paused = true;
    }

    public void stopWalk() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.end();
            this.interrupt();
        } else {
            SwingUtilities.invokeLater(this::stopWalk);
        }
    }

    public void end() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.end = true;
            this.data.removeListener(this);
            StreetsideMainDialog.getInstance().setMode(StreetsideMainDialog.MODE.NORMAL);
        } else {
            SwingUtilities.invokeLater(this::end);
        }
    }
}

