/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.adapter;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.AbstractDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.service.value.Status;
import org.openstreetmap.josm.spi.preferences.Config;

public class WindowClose
extends WindowAdapter {
    private AbstractDialog dialog;
    private MapdustButtonPanel btnPanel;

    public WindowClose() {
    }

    public WindowClose(AbstractDialog dialog, MapdustButtonPanel btnPanel) {
        this.dialog = dialog;
        this.btnPanel = btnPanel;
    }

    @Override
    public void windowClosing(WindowEvent event) {
        String status = Config.getPref().get("selectedBug.status");
        String pluginState = Config.getPref().get("mapdust.pluginState");
        if (this.btnPanel != null) {
            this.btnPanel.getBtnWorkOffline().setEnabled(true);
            this.btnPanel.getBtnWorkOffline().setSelected(false);
            this.btnPanel.getBtnWorkOffline().setFocusable(false);
            this.btnPanel.getBtnFilter().setEnabled(true);
            this.btnPanel.getBtnFilter().setSelected(false);
            this.btnPanel.getBtnFilter().setFocusable(false);
            if (pluginState.equals(MapdustPluginState.OFFLINE.getValue())) {
                this.btnPanel.getBtnRefresh().setEnabled(false);
            } else {
                this.btnPanel.getBtnRefresh().setEnabled(true);
                this.btnPanel.getBtnRefresh().setSelected(false);
                this.btnPanel.getBtnRefresh().setFocusable(false);
            }
            if (status.equals(Status.OPEN.getValue())) {
                this.btnPanel.getBtnFixBugReport().setEnabled(true);
                this.btnPanel.getBtnInvalidateBugReport().setEnabled(true);
                this.btnPanel.getBtnAddComment().setEnabled(true);
            } else if (status.equals(Status.FIXED.getValue())) {
                this.btnPanel.getBtnReOpenBugReport().setEnabled(true);
                this.btnPanel.getBtnAddComment().setEnabled(true);
            } else if (status.equals(Status.INVALID.getValue())) {
                this.btnPanel.getBtnReOpenBugReport().setEnabled(true);
                this.btnPanel.getBtnAddComment().setEnabled(true);
            }
        }
        this.btnPanel.getBtnAddComment().setSelected(false);
        this.btnPanel.getBtnAddComment().setFocusable(false);
        this.btnPanel.getBtnFixBugReport().setSelected(false);
        this.btnPanel.getBtnFixBugReport().setFocusable(false);
        this.btnPanel.getBtnInvalidateBugReport().setSelected(false);
        this.btnPanel.getBtnInvalidateBugReport().setFocusable(false);
        this.btnPanel.getBtnReOpenBugReport().setSelected(false);
        this.btnPanel.getBtnReOpenBugReport().setFocusable(false);
        this.dialog.dispose();
    }
}

