/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.gui;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import java.awt.ComponentOrientation;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class RoutingDialog
extends ToggleDialog {
    private final DefaultListModel<String> model = new DefaultListModel();
    private JList<String> jList = null;
    private JScrollPane jScrollPane = null;
    private static final long serialVersionUID = 8625615652900341987L;

    public RoutingDialog() {
        super(I18n.tr((String)"Routing", (Object[])new Object[0]), "routing", I18n.tr((String)"Open a list of routing nodes", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:routing", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Routing", (Object[])new Object[0])}), (int)82, (int)5010), 150);
        this.createLayout(this.getJScrollPane(), false, null);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList<String> getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.jList.setModel(this.model);
        }
        return this.jList;
    }

    public void removeNode(int index) {
        this.model.remove(index);
    }

    public void addNode(Node n) {
        this.model.addElement(n.getId() + " [" + n.getCoor().toDisplayString() + "]");
    }

    public void insertNode(int index, Node n) {
        this.model.insertElementAt(n.getId() + " [" + n.getCoor().toDisplayString() + "]", index);
    }

    public void clearNodes() {
        this.model.clear();
    }

    public void refresh() {
        this.clearNodes();
        if (MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
            RoutingLayer routingLayer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
            RoutingModel routingModel = routingLayer.getRoutingModel();
            for (Node n : routingModel.getSelectedNodes()) {
                this.addNode(n);
            }
        }
    }
}

