/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.extendable;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.util.extendable.DefaultExtendableItem;
import org.xml.sax.Attributes;

public final class ExtendableItemHelper {
    private ExtendableItemHelper() {
    }

    public static Map<String, String> getExtraAttributes(Attributes attributes, String prefix) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).startsWith(prefix)) continue;
            ret.put(attributes.getQName(i).substring(prefix.length()), attributes.getValue(i));
        }
        return ret;
    }

    @Deprecated
    public static Map<String, String> getExtraAttributes(ParserSettings settings, Attributes attributes, String[] ignoredAttNames) {
        return ExtendableItemHelper.getExtraAttributes(settings, attributes, Arrays.asList(ignoredAttNames));
    }

    public static Map<String, String> getExtraAttributes(ParserSettings settings, Attributes attributes, List<String> ignoredAttNames) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (ignoredAttNames.contains(attributes.getQName(i))) continue;
            ret.put(attributes.getQName(i), settings.substitute(attributes.getValue(i)));
        }
        return ret;
    }

    @Deprecated
    public static void fillExtraAttributes(ParserSettings settings, DefaultExtendableItem item, Attributes attributes, String[] ignoredAttNames) {
        ExtendableItemHelper.fillExtraAttributes(settings, item, attributes, Arrays.asList(ignoredAttNames));
    }

    public static void fillExtraAttributes(ParserSettings settings, DefaultExtendableItem item, Attributes attributes, List<String> ignoredAttNames) {
        Map<String, String> att = ExtendableItemHelper.getExtraAttributes(settings, attributes, ignoredAttNames);
        for (Map.Entry<String, String> entry : att.entrySet()) {
            item.setExtraAttribute(entry.getKey(), entry.getValue());
        }
    }
}

