/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.TimeoutConstrainedURLHandler;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final int BUFFER_SIZE = 65536;
    private static final byte[] EMPTY_BUFFER = new byte[0];

    private FileUtil() {
    }

    public static boolean symlink(File target, File link, boolean overwrite) throws IOException {
        if (!FileUtil.prepareCopy(target, link, overwrite)) {
            return false;
        }
        Files.createSymbolicLink(link.toPath(), target.getAbsoluteFile().toPath(), new FileAttribute[0]);
        return true;
    }

    public static boolean copy(File src, File dest, CopyProgressListener l) throws IOException {
        return FileUtil.copy(src, dest, l, false);
    }

    public static boolean prepareCopy(File src, File dest, boolean overwrite) throws IOException {
        if (src.isDirectory()) {
            if (dest.exists()) {
                if (!dest.isDirectory()) {
                    throw new IOException("impossible to copy: destination is not a directory: " + dest);
                }
            } else {
                dest.mkdirs();
            }
            return true;
        }
        if (dest.exists()) {
            boolean unlinkSymlinkIfOverwrite = true;
            if (!dest.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + dest);
            }
            if (overwrite) {
                if (Files.isSymbolicLink(dest.toPath())) {
                    dest.delete();
                } else if (!dest.canWrite()) {
                    dest.delete();
                }
            } else {
                Message.verbose(dest + " already exists, nothing done");
                return false;
            }
        }
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        return true;
    }

    public static boolean copy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        if (!FileUtil.prepareCopy(src, dest, overwrite)) {
            return false;
        }
        if (src.isDirectory()) {
            return FileUtil.deepCopy(src, dest, l, overwrite);
        }
        FileUtil.copy((InputStream)new FileInputStream(src), dest, l);
        long srcLen = src.length();
        long destLen = dest.length();
        if (srcLen != destLen) {
            dest.delete();
            throw new IOException("size of source file " + src.toString() + "(" + srcLen + ") differs from size of dest file " + dest.toString() + "(" + destLen + ") - please retry");
        }
        dest.setLastModified(src.lastModified());
        return true;
    }

    public static boolean deepCopy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        List<Object> existingChild = Collections.emptyList();
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                dest.delete();
                dest.mkdirs();
                dest.setLastModified(src.lastModified());
            } else {
                File[] children = dest.listFiles();
                if (children != null) {
                    existingChild = Arrays.asList(children);
                }
            }
        } else {
            dest.mkdirs();
            dest.setLastModified(src.lastModified());
        }
        File[] toCopy = src.listFiles();
        if (toCopy != null) {
            for (File cf : toCopy) {
                File childDest = new File(dest, cf.getName());
                existingChild.remove(childDest);
                if (cf.isDirectory()) {
                    FileUtil.deepCopy(cf, childDest, l, overwrite);
                    continue;
                }
                FileUtil.copy(cf, childDest, l, overwrite);
            }
        }
        for (File file : existingChild) {
            FileUtil.forceDelete(file);
        }
        return true;
    }

    public static void copy(URL src, File dest, CopyProgressListener listener, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = URLHandlerRegistry.getDefault();
        if (handler instanceof TimeoutConstrainedURLHandler) {
            ((TimeoutConstrainedURLHandler)handler).download(src, dest, listener, timeoutConstraint);
            return;
        }
        handler.download(src, dest, listener);
    }

    public static void copy(File src, URL dest, CopyProgressListener listener, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = URLHandlerRegistry.getDefault();
        if (handler instanceof TimeoutConstrainedURLHandler) {
            ((TimeoutConstrainedURLHandler)handler).upload(src, dest, listener, timeoutConstraint);
            return;
        }
        handler.upload(src, dest, listener);
    }

    public static void copy(InputStream src, File dest, CopyProgressListener l) throws IOException {
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        FileUtil.copy(src, new FileOutputStream(dest), l);
    }

    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l) throws IOException {
        FileUtil.copy(src, dest, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l, boolean autoClose) throws IOException {
        CopyProgressEvent evt = null;
        if (l != null) {
            evt = new CopyProgressEvent();
        }
        try {
            int c;
            byte[] buffer = new byte[65536];
            long total = 0L;
            if (l != null) {
                l.start(evt);
            }
            while ((c = src.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                dest.write(buffer, 0, c);
                total += (long)c;
                if (l == null) continue;
                l.progress(evt.update(buffer, c, total));
            }
            if (l != null) {
                evt.update(EMPTY_BUFFER, 0, total);
            }
            try {
                dest.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (autoClose) {
                src.close();
                dest.close();
            }
        }
        finally {
            if (autoClose) {
                try {
                    src.close();
                }
                catch (IOException iOException) {}
                try {
                    dest.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (l != null) {
            l.end(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(BufferedReader in) throws IOException {
        try {
            StringBuilder buf = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                buf.append(line).append("\n");
                line = in.readLine();
            }
            String string = buf.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static String readEntirely(File f) throws IOException {
        return FileUtil.readEntirely(new FileInputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(InputStream is) throws IOException {
        try {
            int c;
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[65536];
            while ((c = is.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, c));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            is.close();
        }
    }

    public static String concat(String dir, String file) {
        return dir + "/" + file;
    }

    public static boolean forceDelete(File file) {
        File[] files;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File df : files) {
                if (FileUtil.forceDelete(df)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static List<File> getPathFiles(File root, File file) {
        ArrayList<File> ret = new ArrayList<File>();
        while (file != null && !file.getAbsolutePath().equals(root.getAbsolutePath())) {
            ret.add(file);
            file = file.getParentFile();
        }
        if (root != null) {
            ret.add(root);
        }
        Collections.reverse(ret);
        return ret;
    }

    public static Collection<File> listAll(File dir, Collection<String> ignore) {
        return FileUtil.listAll(dir, new ArrayList<File>(), ignore);
    }

    private static Collection<File> listAll(File file, Collection<File> list, Collection<String> ignore) {
        if (ignore.contains(file.getName())) {
            return list;
        }
        if (file.exists()) {
            list.add(file);
        }
        if (file.isDirectory()) {
            File[] files;
            for (File lf : files = file.listFiles()) {
                FileUtil.listAll(lf, list, ignore);
            }
        }
        return list;
    }

    public static File resolveFile(File file, String filename) {
        File result = new File(filename);
        if (!result.isAbsolute()) {
            result = new File(file, filename);
        }
        return FileUtil.normalize(result.getPath());
    }

    public static File normalize(String path) {
        Stack<String> s = new Stack<String>();
        DissectedPath dissectedPath = FileUtil.dissect(path);
        s.push(dissectedPath.root);
        StringTokenizer tok = new StringTokenizer(dissectedPath.remainingPath, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    return new File(path);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append((String)s.elementAt(i));
        }
        return new File(sb.toString());
    }

    private static DissectedPath dissect(String path) {
        char sep = File.separatorChar;
        String pathToDissect = path.replace('/', sep).replace('\\', sep).trim();
        File[] filesystemRoots = File.listRoots();
        if (filesystemRoots != null) {
            for (File filesystemRoot : filesystemRoots) {
                if (!pathToDissect.startsWith(filesystemRoot.getPath())) continue;
                String root = filesystemRoot.getPath();
                String rest = pathToDissect.substring(root.length());
                StringBuilder sbPath = new StringBuilder();
                for (int i = 0; i < rest.length(); ++i) {
                    char currentChar = rest.charAt(i);
                    if (i == 0) {
                        sbPath.append(currentChar);
                        continue;
                    }
                    char previousChar = rest.charAt(i - 1);
                    if (currentChar == sep && previousChar == sep) continue;
                    sbPath.append(currentChar);
                }
                return new DissectedPath(root, sbPath.toString());
            }
        }
        if (pathToDissect.length() > 1 && pathToDissect.charAt(1) == sep) {
            int nextsep = pathToDissect.indexOf(sep, 2);
            String root = (nextsep = pathToDissect.indexOf(sep, nextsep + 1)) > 2 ? pathToDissect.substring(0, nextsep + 1) : pathToDissect;
            String rest = pathToDissect.substring(root.length());
            return new DissectedPath(root, rest);
        }
        return new DissectedPath(File.separator, pathToDissect);
    }

    public static long getFileLength(File file) {
        long l = 0L;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File gf : files) {
                    l += FileUtil.getFileLength(gf);
                }
            }
        } else {
            l = file.length();
        }
        return l;
    }

    public static InputStream unwrapPack200(InputStream packed) throws IOException {
        BufferedInputStream buffered = new BufferedInputStream(packed);
        buffered.mark(4);
        byte[] magic = new byte[4];
        buffered.read(magic, 0, 4);
        buffered.reset();
        FilterInputStream in = buffered;
        if (magic[0] == 31 && magic[1] == -117 && magic[2] == 8) {
            in = new GZIPInputStream(in);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream(baos);
        Pack200.newUnpacker().unpack((InputStream)new UncloseInputStream(in), jar);
        jar.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static final class DissectedPath {
        private final String root;
        private final String remainingPath;

        private DissectedPath(String root, String remainingPath) {
            this.root = root;
            this.remainingPath = remainingPath;
        }

        public String toString() {
            return "Dissected Path [root=" + this.root + ", remainingPath=" + this.remainingPath + "]";
        }
    }

    private static final class UncloseInputStream
    extends InputStream {
        private InputStream wrapped;

        public UncloseInputStream(InputStream wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            return this.wrapped.read();
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.wrapped.read(b);
        }

        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.wrapped.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        public String toString() {
            return this.wrapped.toString();
        }

        @Override
        public int available() throws IOException {
            return this.wrapped.available();
        }

        @Override
        public void mark(int readlimit) {
            this.wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }
}

