/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.parser.m2.PomWriterOptions;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.StringUtils;

public final class PomModuleDescriptorWriter {
    private static final String SKIP_LINE = "SKIP_LINE";
    private static final PomWriterOptions.ConfigurationScopeMapping DEFAULT_MAPPING = new PomWriterOptions.ConfigurationScopeMapping((Map<String, String>)new LinkedHashMap<String, String>(){
        {
            this.put("compile", "compile");
            this.put("runtime", "runtime");
            this.put("provided", "provided");
            this.put("test", "test");
            this.put("system", "system");
        }
    });

    private PomModuleDescriptorWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ModuleDescriptor md, File output, PomWriterOptions options) throws IOException {
        LineNumberReader in = options.getTemplate() == null ? new LineNumberReader(new InputStreamReader(PomModuleDescriptorWriter.class.getResourceAsStream("pom.template"))) : new LineNumberReader(new InputStreamReader(new FileInputStream(options.getTemplate())));
        if (output.getParentFile() != null) {
            output.getParentFile().mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        try {
            IvySettings settings = IvyContext.getContext().getSettings();
            IvyVariableContainerWrapper variables = new IvyVariableContainerWrapper(settings.getVariableContainer());
            variables.setVariable("ivy.pom.license", SKIP_LINE, true);
            variables.setVariable("ivy.pom.header", SKIP_LINE, true);
            variables.setVariable("ivy.pom.groupId", SKIP_LINE, true);
            variables.setVariable("ivy.pom.artifactId", SKIP_LINE, true);
            variables.setVariable("ivy.pom.version", SKIP_LINE, true);
            variables.setVariable("ivy.pom.packaging", SKIP_LINE, true);
            variables.setVariable("ivy.pom.name", SKIP_LINE, true);
            variables.setVariable("ivy.pom.description", SKIP_LINE, true);
            variables.setVariable("ivy.pom.url", SKIP_LINE, true);
            if (options.getLicenseHeader() != null) {
                variables.setVariable("ivy.pom.license", options.getLicenseHeader(), true);
            }
            if (options.isPrintIvyInfo()) {
                String header = "<!--\n   Apache Maven 2 POM generated by Apache Ivy\n   " + Ivy.getIvyHomeURL() + "\n   Apache Ivy version: " + Ivy.getIvyVersion() + " " + Ivy.getIvyDate() + "\n-->";
                variables.setVariable("ivy.pom.header", header, true);
            }
            PomModuleDescriptorWriter.setModuleVariables(md, variables, options);
            boolean dependenciesPrinted = false;
            int lastIndent = 0;
            int indent = 0;
            String line = in.readLine();
            while (line != null) {
                if ((line = IvyPatternHelper.substituteVariables(line, variables)).contains(SKIP_LINE)) {
                    line = in.readLine();
                    continue;
                }
                if (line.trim().isEmpty()) {
                    out.println(line);
                    line = in.readLine();
                    continue;
                }
                lastIndent = indent;
                indent = line.indexOf(60);
                if (!dependenciesPrinted && line.contains("</dependencies>")) {
                    PomModuleDescriptorWriter.printDependencies(md, out, options, indent, false);
                    dependenciesPrinted = true;
                }
                if (!dependenciesPrinted && line.contains("</project>")) {
                    PomModuleDescriptorWriter.printDependencies(md, out, options, lastIndent, true);
                    dependenciesPrinted = true;
                }
                out.println(line);
                line = in.readLine();
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static void setModuleVariables(ModuleDescriptor md, IvyVariableContainer variables, PomWriterOptions options) {
        String packaging;
        ModuleRevisionId mrid = md.getModuleRevisionId();
        variables.setVariable("ivy.pom.groupId", mrid.getOrganisation(), true);
        String artifactId = options.getArtifactName();
        if (artifactId == null) {
            artifactId = mrid.getName();
        }
        if ((packaging = options.getArtifactPackaging()) == null) {
            Artifact artifact = PomModuleDescriptorWriter.findArtifact(md, artifactId);
            packaging = artifact == null ? "pom" : artifact.getType();
        }
        variables.setVariable("ivy.pom.artifactId", artifactId, true);
        variables.setVariable("ivy.pom.packaging", packaging, true);
        if (mrid.getRevision() != null) {
            variables.setVariable("ivy.pom.version", mrid.getRevision(), true);
        }
        if (options.getDescription() != null) {
            variables.setVariable("ivy.pom.description", options.getDescription(), true);
        } else if (!StringUtils.isNullOrEmpty(md.getDescription())) {
            variables.setVariable("ivy.pom.description", md.getDescription(), true);
        }
        if (md.getHomePage() != null) {
            variables.setVariable("ivy.pom.url", md.getHomePage(), true);
        }
    }

    private static Artifact findArtifact(ModuleDescriptor md, String artifactName) {
        for (Artifact artifact : md.getAllArtifacts()) {
            if (!artifact.getName().equals(artifactName) || artifact.getAttribute("classifier") != null) continue;
            return artifact;
        }
        return null;
    }

    private static void indent(PrintWriter out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
    }

    private static void printDependencies(ModuleDescriptor md, PrintWriter out, PomWriterOptions options, int indent, boolean printDependencies) {
        List<PomWriterOptions.ExtraDependency> extraDeps = options.getExtraDependencies();
        DependencyDescriptor[] dds = PomModuleDescriptorWriter.getDependencies(md, options);
        if (!extraDeps.isEmpty() || dds.length > 0) {
            if (printDependencies) {
                PomModuleDescriptorWriter.indent(out, indent);
                out.println("<dependencies>");
            }
            for (PomWriterOptions.ExtraDependency dep : extraDeps) {
                String version;
                String groupId = dep.getGroup();
                if (groupId == null) {
                    groupId = md.getModuleRevisionId().getOrganisation();
                }
                if ((version = dep.getVersion()) == null) {
                    version = md.getModuleRevisionId().getRevision();
                }
                PomModuleDescriptorWriter.printDependency(out, indent, groupId, dep.getArtifact(), version, dep.getType(), dep.getClassifier(), dep.getScope(), dep.isOptional(), true, null);
            }
            PomWriterOptions.ConfigurationScopeMapping mapping = options.getMapping();
            if (mapping == null) {
                mapping = DEFAULT_MAPPING;
            }
            for (DependencyDescriptor dd : dds) {
                DependencyArtifactDescriptor[] dads;
                ModuleRevisionId mrid = dd.getDependencyRevisionId();
                ExcludeRule[] excludes = null;
                if (dd.canExclude()) {
                    excludes = dd.getAllExcludeRules();
                }
                if ((dads = dd.getAllDependencyArtifacts()).length > 0) {
                    for (DependencyArtifactDescriptor dad : dads) {
                        String type = dad.getType();
                        String classifier = dad.getExtraAttribute("classifier");
                        String scope = mapping.getScope(dd.getModuleConfigurations());
                        boolean optional = mapping.isOptional(dd.getModuleConfigurations());
                        PomModuleDescriptorWriter.printDependency(out, indent, mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), type, classifier, scope, optional, dd.isTransitive(), excludes);
                    }
                    continue;
                }
                String scope = mapping.getScope(dd.getModuleConfigurations());
                boolean optional = mapping.isOptional(dd.getModuleConfigurations());
                String classifier = dd.getExtraAttribute("classifier");
                PomModuleDescriptorWriter.printDependency(out, indent, mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), null, classifier, scope, optional, dd.isTransitive(), excludes);
            }
            if (printDependencies) {
                PomModuleDescriptorWriter.indent(out, indent);
                out.println("</dependencies>");
            }
        }
    }

    private static void printDependency(PrintWriter out, int indent, String groupId, String artifactId, String version, String type, String classifier, String scope, boolean isOptional, boolean isTransitive, ExcludeRule[] excludes) {
        PomModuleDescriptorWriter.indent(out, indent * 2);
        out.println("<dependency>");
        PomModuleDescriptorWriter.indent(out, indent * 3);
        out.println("<groupId>" + groupId + "</groupId>");
        PomModuleDescriptorWriter.indent(out, indent * 3);
        out.println("<artifactId>" + artifactId + "</artifactId>");
        PomModuleDescriptorWriter.indent(out, indent * 3);
        out.println("<version>" + version + "</version>");
        if (type != null && !"jar".equals(type)) {
            PomModuleDescriptorWriter.indent(out, indent * 3);
            out.println("<type>" + type + "</type>");
        }
        if (classifier != null) {
            PomModuleDescriptorWriter.indent(out, indent * 3);
            out.println("<classifier>" + classifier + "</classifier>");
        }
        if (scope != null) {
            PomModuleDescriptorWriter.indent(out, indent * 3);
            out.println("<scope>" + scope + "</scope>");
        }
        if (isOptional) {
            PomModuleDescriptorWriter.indent(out, indent * 3);
            out.println("<optional>true</optional>");
        }
        if (!isTransitive) {
            PomModuleDescriptorWriter.indent(out, indent * 3);
            out.println("<exclusions>");
            PomModuleDescriptorWriter.indent(out, indent * 4);
            out.println("<exclusion>");
            PomModuleDescriptorWriter.indent(out, indent * 5);
            out.println("<groupId>*</groupId>");
            PomModuleDescriptorWriter.indent(out, indent * 5);
            out.println("<artifactId>*</artifactId>");
            PomModuleDescriptorWriter.indent(out, indent * 4);
            out.println("</exclusion>");
            PomModuleDescriptorWriter.indent(out, indent * 3);
            out.println("</exclusions>");
        } else if (excludes != null) {
            PomModuleDescriptorWriter.printExclusions(excludes, out, indent);
        }
        PomModuleDescriptorWriter.indent(out, indent * 2);
        out.println("</dependency>");
    }

    private static void printExclusions(ExcludeRule[] exclusions, PrintWriter out, int indent) {
        PomModuleDescriptorWriter.indent(out, indent * 3);
        out.println("<exclusions>");
        for (ExcludeRule exclusion : exclusions) {
            PomModuleDescriptorWriter.indent(out, indent * 4);
            out.println("<exclusion>");
            PomModuleDescriptorWriter.indent(out, indent * 5);
            out.println("<groupId>" + exclusion.getId().getModuleId().getOrganisation() + "</groupId>");
            PomModuleDescriptorWriter.indent(out, indent * 5);
            out.println("<artifactId>" + exclusion.getId().getModuleId().getName() + "</artifactId>");
            PomModuleDescriptorWriter.indent(out, indent * 4);
            out.println("</exclusion>");
        }
        PomModuleDescriptorWriter.indent(out, indent * 3);
        out.println("</exclusions>");
    }

    private static DependencyDescriptor[] getDependencies(ModuleDescriptor md, PomWriterOptions options) {
        String[] confs = ConfigurationUtils.replaceWildcards(options.getConfs(), md);
        ArrayList<DependencyDescriptor> result = new ArrayList<DependencyDescriptor>();
        for (DependencyDescriptor dd : md.getDependencies()) {
            String[] depConfs = dd.getDependencyConfigurations(confs);
            if (depConfs == null || depConfs.length <= 0) continue;
            result.add(dd);
        }
        return result.toArray(new DependencyDescriptor[result.size()]);
    }

    private static final class IvyVariableContainerWrapper
    implements IvyVariableContainer {
        private final IvyVariableContainer variables;
        private Map<String, String> localVariables = new HashMap<String, String>();

        private IvyVariableContainerWrapper(IvyVariableContainer variables) {
            this.variables = variables;
        }

        @Override
        public void setVariable(String varName, String value, boolean overwrite) {
            this.localVariables.put(varName, value);
        }

        @Override
        public void setEnvironmentPrefix(String prefix) {
            this.variables.setEnvironmentPrefix(prefix);
        }

        @Override
        public String getVariable(String name) {
            String result = this.variables.getVariable(name);
            if (result == null) {
                result = this.localVariables.get(name);
            }
            return result;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }
}

