/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Configurator;
import org.apache.ivy.util.FileResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSettingsParser
extends DefaultHandler {
    private Configurator configurator;
    private List<String> configuratorTags = Arrays.asList("resolvers", "namespaces", "parsers", "latest-strategies", "conflict-managers", "outputters", "version-matchers", "statuses", "circular-dependency-strategies", "triggers", "lock-strategies", "caches", "signers", "timeout-constraints");
    private IvySettings ivy;
    private String defaultResolver;
    private String defaultCM;
    private String defaultLatest;
    private String defaultCacheManager;
    private String defaultCircular;
    private String defaultLock;
    private String currentConfiguratorTag;
    private URL settings;
    private boolean deprecatedMessagePrinted = false;

    public XmlSettingsParser(IvySettings ivy) {
        this.ivy = ivy;
    }

    public void parse(URL settings) throws ParseException, IOException {
        this.configurator = new Configurator();
        this.configurator.setFileResolver(new FileResolver(){

            @Override
            public File resolveFile(String path, String filename) {
                return Checks.checkAbsolute(path, filename);
            }
        });
        for (Map.Entry<String, Class<?>> entry : this.ivy.getTypeDefs().entrySet()) {
            this.configurator.typeDef(entry.getKey(), entry.getValue());
        }
        this.doParse(settings);
    }

    private void doParse(URL settingsUrl) throws IOException, ParseException {
        this.settings = settingsUrl;
        InputStream stream = null;
        try {
            stream = URLHandlerRegistry.getDefault().openStream(settingsUrl);
            InputSource inSrc = new InputSource(stream);
            inSrc.setSystemId(settingsUrl.toExternalForm());
            SAXParserFactory.newInstance().newSAXParser().parse(settingsUrl.toExternalForm(), (DefaultHandler)this);
            this.ivy.validate();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            ParseException pe = new ParseException("failed to load settings from " + settingsUrl + ": " + e.getMessage(), 0);
            pe.initCause(e);
            throw pe;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parse(Configurator configurator, URL configuration) throws IOException, ParseException {
        this.configurator = configurator;
        this.doParse(configuration);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < att.getLength(); ++i) {
            attributes.put(att.getQName(i), this.ivy.substitute(att.getValue(i)));
        }
        try {
            if ("ivyconf".equals(qName)) {
                this.deprecatedMessagePrinted = true;
                Message.deprecated("'ivyconf' element is deprecated, use 'ivysettings' instead (" + this.settings + ")");
            }
            if (this.configurator.getCurrent() != null) {
                this.inConfiguratorStarted(qName, attributes);
            } else if ("classpath".equals(qName)) {
                this.classpathStarted(attributes);
            } else if ("typedef".equals(qName)) {
                this.typedefStarted(attributes);
            } else if ("property".equals(qName)) {
                this.propertyStarted(attributes);
            } else if ("properties".equals(qName)) {
                this.propertiesStarted(attributes);
            } else if ("include".equals(qName)) {
                this.includeStarted(attributes);
            } else if ("settings".equals(qName) || "conf".equals(qName)) {
                this.settingsStarted(qName, attributes);
            } else if ("caches".equals(qName)) {
                this.cachesStarted(qName, attributes);
            } else if ("version-matchers".equals(qName)) {
                this.versionMatchersStarted(qName, attributes);
            } else if ("statuses".equals(qName)) {
                this.statusesStarted(qName, attributes);
            } else if (this.configuratorTags.contains(qName)) {
                this.anyConfiguratorStarted(qName);
            } else if ("macrodef".equals(qName)) {
                this.macrodefStarted(qName, attributes);
            } else if ("module".equals(qName)) {
                this.moduleStarted(attributes);
            } else if ("credentials".equals(qName)) {
                this.credentialsStarted(attributes);
            }
        }
        catch (ParseException ex) {
            throw new SAXException("problem in config file: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new SAXException("io problem while parsing config file: " + ex.getMessage(), ex);
        }
    }

    private void credentialsStarted(Map<String, String> attributes) {
        String realm = attributes.remove("realm");
        String host = attributes.remove("host");
        String userName = attributes.remove("username");
        String passwd = attributes.remove("passwd");
        CredentialsStore.INSTANCE.addCredentials(realm, host, userName, passwd);
    }

    private void moduleStarted(Map<String, String> attributes) {
        attributes.put("module", attributes.remove("name"));
        String resolver = attributes.remove("resolver");
        String branch = attributes.remove("branch");
        String cm = attributes.remove("conflict-manager");
        String resolveMode = attributes.remove("resolveMode");
        String matcher = attributes.remove("matcher");
        matcher = matcher == null ? "exactOrRegexp" : matcher;
        this.ivy.addModuleConfiguration(attributes, this.ivy.getMatcher(matcher), resolver, branch, cm, resolveMode);
    }

    private void macrodefStarted(String qName, Map<String, String> attributes) {
        this.currentConfiguratorTag = qName;
        Configurator.MacroDef macrodef = this.configurator.startMacroDef(attributes.get("name"));
        macrodef.addAttribute("name", null);
    }

    private void anyConfiguratorStarted(String qName) {
        this.currentConfiguratorTag = qName;
        this.configurator.setRoot(this.ivy);
    }

    private void statusesStarted(String qName, Map<String, String> attributes) {
        this.currentConfiguratorTag = qName;
        StatusManager m = new StatusManager();
        String defaultStatus = attributes.get("default");
        if (defaultStatus != null) {
            m.setDefaultStatus(defaultStatus);
        }
        this.ivy.setStatusManager(m);
        this.configurator.setRoot(m);
    }

    private void versionMatchersStarted(String qName, Map<String, String> attributes) {
        this.anyConfiguratorStarted(qName);
        if ("true".equals(attributes.get("usedefaults"))) {
            this.ivy.configureDefaultVersionMatcher();
        }
    }

    private void cachesStarted(String qName, Map<String, String> attributes) {
        String repositoryDir;
        String cacheArtPattern;
        String cacheIvyPattern;
        String useOrigin;
        String resolutionDir;
        String up2d;
        this.anyConfiguratorStarted(qName);
        this.defaultLock = attributes.get("lockStrategy");
        this.defaultCacheManager = attributes.get("default");
        String cache = attributes.get("defaultCacheDir");
        if (cache != null) {
            this.ivy.setDefaultCache(Checks.checkAbsolute(cache, "defaultCacheDir"));
        }
        if ((up2d = attributes.get("checkUpToDate")) != null) {
            Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + this.settings + ")");
            this.ivy.setCheckUpToDate(Boolean.valueOf(up2d));
        }
        if ((resolutionDir = attributes.get("resolutionCacheDir")) != null) {
            this.ivy.setDefaultResolutionCacheBasedir(resolutionDir);
        }
        if ((useOrigin = attributes.get("useOrigin")) != null) {
            this.ivy.setDefaultUseOrigin(Boolean.valueOf(useOrigin));
        }
        if ((cacheIvyPattern = attributes.get("ivyPattern")) != null) {
            this.ivy.setDefaultCacheIvyPattern(cacheIvyPattern);
        }
        if ((cacheArtPattern = attributes.get("artifactPattern")) != null) {
            this.ivy.setDefaultCacheArtifactPattern(cacheArtPattern);
        }
        if ((repositoryDir = attributes.get("repositoryCacheDir")) != null) {
            this.ivy.setDefaultRepositoryCacheBasedir(repositoryDir);
        }
    }

    private void settingsStarted(String qName, Map<String, String> attributes) {
        String cacheArtPattern;
        String cacheIvyPattern;
        String useRemoteConfig;
        String up2d;
        String validate;
        String defaultResolveMode;
        String defaultBranch;
        String cache;
        if ("conf".equals(qName) && !this.deprecatedMessagePrinted) {
            Message.deprecated("'conf' is deprecated, use 'settings' instead (" + this.settings + ")");
        }
        if ((cache = attributes.get("defaultCache")) != null) {
            Message.deprecated("'defaultCache' is deprecated, use 'caches[@defaultCacheDir]' instead (" + this.settings + ")");
            this.ivy.setDefaultCache(Checks.checkAbsolute(cache, "defaultCache"));
        }
        if ((defaultBranch = attributes.get("defaultBranch")) != null) {
            this.ivy.setDefaultBranch(defaultBranch);
        }
        if ((defaultResolveMode = attributes.get("defaultResolveMode")) != null) {
            this.ivy.setDefaultResolveMode(defaultResolveMode);
        }
        if ((validate = attributes.get("validate")) != null) {
            this.ivy.setValidate(Boolean.valueOf(validate));
        }
        if ((up2d = attributes.get("checkUpToDate")) != null) {
            Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + this.settings + ")");
            this.ivy.setCheckUpToDate(Boolean.valueOf(up2d));
        }
        if ((useRemoteConfig = attributes.get("useRemoteConfig")) != null) {
            this.ivy.setUseRemoteConfig(Boolean.valueOf(useRemoteConfig));
        }
        if ((cacheIvyPattern = attributes.get("cacheIvyPattern")) != null) {
            Message.deprecated("'cacheIvyPattern' is deprecated, use 'caches[@ivyPattern]' instead (" + this.settings + ")");
            this.ivy.setDefaultCacheIvyPattern(cacheIvyPattern);
        }
        if ((cacheArtPattern = attributes.get("cacheArtifactPattern")) != null) {
            Message.deprecated("'cacheArtifactPattern' is deprecated, use 'caches[@artifactPattern]' instead (" + this.settings + ")");
            this.ivy.setDefaultCacheArtifactPattern(cacheArtPattern);
        }
        this.defaultResolver = attributes.get("defaultResolver");
        this.defaultCM = attributes.get("defaultConflictManager");
        this.defaultLatest = attributes.get("defaultLatestStrategy");
        this.defaultCircular = attributes.get("circularDependencyStrategy");
        String requestMethod = attributes.get("httpRequestMethod");
        if ("head".equalsIgnoreCase(requestMethod)) {
            URLHandlerRegistry.getHttp().setRequestMethod(2);
        } else if ("get".equalsIgnoreCase(requestMethod)) {
            URLHandlerRegistry.getHttp().setRequestMethod(1);
        } else if (!StringUtils.isNullOrEmpty(requestMethod)) {
            throw new IllegalArgumentException("Invalid httpRequestMethod specified, must be one of {'HEAD', 'GET'}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void includeStarted(Map<String, String> attributes) throws IOException, ParseException {
        IvyVariableContainer variables = this.ivy.getVariableContainer();
        this.ivy.setVariableContainer(new IvyVariableContainerWrapper(variables));
        boolean optionalInclude = "true".equals(attributes.get("optional"));
        try {
            URL settingsURL;
            block25: {
                block23: {
                    File settingsFile;
                    String propFilePath;
                    block24: {
                        propFilePath = attributes.get("file");
                        settingsURL = null;
                        if (propFilePath != null) break block24;
                        propFilePath = attributes.get("url");
                        if (propFilePath == null) {
                            throw new IllegalArgumentException("bad include tag: specify file or url to include");
                        }
                        try {
                            try {
                                settingsURL = new URL(propFilePath);
                            }
                            catch (MalformedURLException e) {
                                settingsURL = new URL(this.settings, propFilePath);
                            }
                        }
                        catch (IOException ioe) {
                            if (!optionalInclude) {
                                throw ioe;
                            }
                            Message.verbose("Skipping inclusion of optional URL " + propFilePath + " due to IOException - " + ioe.getMessage());
                            this.ivy.setVariableContainer(variables);
                            return;
                        }
                        Message.verbose("including url: " + settingsURL.toString());
                        this.ivy.setSettingsVariables(settingsURL);
                        break block25;
                    }
                    try {
                        settingsURL = this.urlFromFileAttribute(propFilePath);
                        Message.verbose("including file: " + settingsURL);
                        if (!"file".equals(settingsURL.getProtocol())) break block23;
                        try {
                            settingsFile = new File(new URI(settingsURL.toExternalForm()));
                            if (optionalInclude && !settingsFile.exists()) {
                                return;
                            }
                        }
                        catch (URISyntaxException e) {
                            this.ivy.setSettingsVariables(Checks.checkAbsolute(settingsURL.getPath(), "settings include path"));
                        }
                    }
                    catch (IOException ioe) {
                        if (!optionalInclude) {
                            throw ioe;
                        }
                        Message.verbose("Skipping inclusion of optional file " + propFilePath + " due to IOException - " + ioe.getMessage());
                        this.ivy.setVariableContainer(variables);
                        return;
                    }
                    {
                        this.ivy.setSettingsVariables(Checks.checkAbsolute(settingsFile, "settings include path"));
                    }
                    break block25;
                }
                this.ivy.setSettingsVariables(settingsURL);
            }
            try {
                new XmlSettingsParser(this.ivy).parse(this.configurator, settingsURL);
                return;
            }
            catch (IOException ioe) {
                if (!optionalInclude) {
                    throw ioe;
                }
                Message.verbose("Skipping inclusion of optional settings URL " + settingsURL + " due to IOException - " + ioe.getMessage());
                this.ivy.setVariableContainer(variables);
                return;
            }
        }
        finally {
            this.ivy.setVariableContainer(variables);
        }
    }

    private URL urlFromFileAttribute(String filePath) throws IOException {
        try {
            return new URL(filePath);
        }
        catch (MalformedURLException malformedURLException) {
            File incFile = new File(filePath);
            if (incFile.isAbsolute()) {
                if (!incFile.exists()) {
                    throw new FileNotFoundException(incFile.getAbsolutePath());
                }
                return incFile.toURI().toURL();
            }
            if ("file".equals(this.settings.getProtocol())) {
                try {
                    File settingsFile = new File(new URI(this.settings.toExternalForm()));
                    if (!settingsFile.exists()) {
                        throw new FileNotFoundException(settingsFile.getAbsolutePath());
                    }
                    return new File(settingsFile.getParentFile(), filePath).toURI().toURL();
                }
                catch (URISyntaxException e) {
                    return new URL(this.settings, filePath);
                }
            }
            return new URL(this.settings, filePath);
        }
    }

    private void propertiesStarted(Map<String, String> attributes) throws IOException {
        String propFilePath = attributes.get("file");
        String environmentPrefix = attributes.get("environment");
        if (propFilePath != null) {
            String overrideStr = attributes.get("override");
            boolean override = overrideStr == null || Boolean.valueOf(overrideStr) != false;
            Message.verbose("loading properties: " + propFilePath);
            try {
                URL fileUrl = this.urlFromFileAttribute(propFilePath);
                this.ivy.loadProperties(fileUrl, override);
            }
            catch (FileNotFoundException e) {
                Message.verbose("Unable to find property file: " + propFilePath);
            }
        } else if (environmentPrefix != null) {
            this.ivy.getVariableContainer().setEnvironmentPrefix(environmentPrefix);
        } else {
            throw new IllegalArgumentException("Didn't find a 'file' or 'environment' attribute on the 'properties' element");
        }
    }

    private void propertyStarted(Map<String, String> attributes) {
        String name = attributes.get("name");
        String value = attributes.get("value");
        String override = attributes.get("override");
        String isSetVar = attributes.get("ifset");
        String unlessSetVar = attributes.get("unlessset");
        if (name == null) {
            throw new IllegalArgumentException("missing attribute name on property tag");
        }
        if (value == null) {
            throw new IllegalArgumentException("missing attribute value on property tag");
        }
        this.ivy.setVariable(name, value, override == null || Boolean.valueOf(override) != false, isSetVar, unlessSetVar);
    }

    private void typedefStarted(Map<String, String> attributes) {
        String name = attributes.get("name");
        String className = attributes.get("classname");
        Class<?> clazz = this.ivy.typeDef(name, className);
        this.configurator.typeDef(name, clazz);
    }

    private void classpathStarted(Map<String, String> attributes) throws IOException {
        String urlStr = attributes.get("url");
        URL url = null;
        if (urlStr == null) {
            String file = attributes.get("file");
            if (file == null) {
                throw new IllegalArgumentException("either url or file should be given for classpath element");
            }
            url = this.urlFromFileAttribute(file);
        } else {
            url = new URL(urlStr);
        }
        this.ivy.addClasspathURL(url);
    }

    private void inConfiguratorStarted(String qName, Map<String, String> attributes) {
        String name;
        if ("macrodef".equals(this.currentConfiguratorTag) && this.configurator.getTypeDef(qName) != null) {
            name = attributes.get("name");
            if (name == null) {
                attributes.put("name", "@{name}");
            } else if (name.contains("@{name}")) {
                attributes.put("name", name);
            } else {
                attributes.put("name", "@{name}-" + name);
            }
        }
        if (attributes.get("ref") != null) {
            if (attributes.size() != 1) {
                throw new IllegalArgumentException("ref attribute should be the only one ! found " + attributes.size() + " in " + qName);
            }
            name = attributes.get("ref");
            Object child = null;
            if ("resolvers".equals(this.currentConfiguratorTag) || "resolver".equals(qName)) {
                child = this.ivy.getResolver(name);
                if (child == null) {
                    throw new IllegalArgumentException("unknown resolver " + name + ": resolver should be defined before being referenced");
                }
            } else if ("latest-strategies".equals(this.currentConfiguratorTag)) {
                child = this.ivy.getLatestStrategy(name);
                if (child == null) {
                    throw new IllegalArgumentException("unknown latest strategy " + name + ": latest strategy should be defined before being referenced");
                }
            } else if ("conflict-managers".equals(this.currentConfiguratorTag) && (child = this.ivy.getConflictManager(name)) == null) {
                throw new IllegalArgumentException("unknown conflict manager " + name + ": conflict manager should be defined before being referenced");
            }
            if (child == null) {
                throw new IllegalArgumentException("bad reference " + name);
            }
            this.configurator.addChild(qName, child);
        } else {
            this.configurator.startCreateChild(qName);
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                this.configurator.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.configurator.getCurrent() != null) {
            if (this.configuratorTags.contains(qName) && this.configurator.getDepth() == 1) {
                this.configurator.clear();
                this.currentConfiguratorTag = null;
            } else if ("macrodef".equals(qName) && this.configurator.getDepth() == 1) {
                this.configurator.endMacroDef();
                this.currentConfiguratorTag = null;
            } else {
                this.configurator.endCreateChild();
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        Object strategy;
        if (this.defaultResolver != null) {
            this.ivy.setDefaultResolver(this.ivy.substitute(this.defaultResolver));
        }
        if (this.defaultCM != null) {
            ConflictManager conflictManager = this.ivy.getConflictManager(this.ivy.substitute(this.defaultCM));
            if (conflictManager == null) {
                throw new IllegalArgumentException("unknown conflict manager " + this.ivy.substitute(this.defaultCM));
            }
            this.ivy.setDefaultConflictManager(conflictManager);
        }
        if (this.defaultLatest != null) {
            LatestStrategy latestStrategy = this.ivy.getLatestStrategy(this.ivy.substitute(this.defaultLatest));
            if (latestStrategy == null) {
                throw new IllegalArgumentException("unknown latest strategy " + this.ivy.substitute(this.defaultLatest));
            }
            this.ivy.setDefaultLatestStrategy(latestStrategy);
        }
        if (this.defaultCacheManager != null) {
            RepositoryCacheManager cache = this.ivy.getRepositoryCacheManager(this.ivy.substitute(this.defaultCacheManager));
            if (cache == null) {
                throw new IllegalArgumentException("unknown cache manager " + this.ivy.substitute(this.defaultCacheManager));
            }
            this.ivy.setDefaultRepositoryCacheManager(cache);
        }
        if (this.defaultCircular != null) {
            strategy = this.ivy.getCircularDependencyStrategy(this.ivy.substitute(this.defaultCircular));
            if (strategy == null) {
                throw new IllegalArgumentException("unknown circular dependency strategy " + this.ivy.substitute(this.defaultCircular));
            }
            this.ivy.setCircularDependencyStrategy((CircularDependencyStrategy)strategy);
        }
        if (this.defaultLock != null) {
            strategy = this.ivy.getLockStrategy(this.ivy.substitute(this.defaultLock));
            if (strategy == null) {
                throw new IllegalArgumentException("unknown lock strategy " + this.ivy.substitute(this.defaultLock));
            }
            this.ivy.setDefaultLockStrategy((LockStrategy)strategy);
        }
    }

    private static final class IvyVariableContainerWrapper
    implements IvyVariableContainer {
        private static final Collection<String> SETTINGS_VARIABLES = Arrays.asList("ivy.settings.dir", "ivy.settings.url", "ivy.settings.file", "ivy.conf.dir", "ivy.conf.url", "ivy.conf.file");
        private final IvyVariableContainer variables;
        private Map<String, String> localVariables = new HashMap<String, String>();

        private IvyVariableContainerWrapper(IvyVariableContainer variables) {
            this.variables = variables;
        }

        @Override
        public void setVariable(String varName, String value, boolean overwrite) {
            if (SETTINGS_VARIABLES.contains(varName)) {
                if (!this.localVariables.containsKey(varName) || overwrite) {
                    this.localVariables.put(varName, value);
                }
            } else {
                this.variables.setVariable(varName, value, overwrite);
            }
        }

        @Override
        public void setEnvironmentPrefix(String prefix) {
            this.variables.setEnvironmentPrefix(prefix);
        }

        @Override
        public String getVariable(String name) {
            if (this.localVariables.containsKey(name)) {
                return this.localVariables.get(name);
            }
            return this.variables.getVariable(name);
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }
    }
}

