/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2004-2005, Open Geospatial Consortium Inc.
 *
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.opengis.metadata.spatial;

import static org.opengis.annotation.Obligation.*;
import static org.opengis.annotation.Specification.*;

import java.util.ArrayList;
import java.util.List;
import org.opengis.annotation.UML;
import org.opengis.util.CodeList;

/**
 * Code indicating whether grid data is point or area.
 *
 * @source $URL$
 * @version <A HREF="http://www.opengeospatial.org/standards/as#01-111">ISO 19115</A>
 * @author Martin Desruisseaux (IRD)
 * @since GeoAPI 2.0
 */
@UML(identifier = "MD_CellGeometryCode", specification = ISO_19115)
public final class CellGeometry extends CodeList<CellGeometry> {
    /** Serial number for compatibility with different versions. */
    private static final long serialVersionUID = -1901029875497457189L;

    /** List of all enumerations of this type. Must be declared before any enum declaration. */
    private static final List<CellGeometry> VALUES = new ArrayList<CellGeometry>(2);

    /** Each cell represents a point. */
    @UML(identifier = "point", obligation = CONDITIONAL, specification = ISO_19115)
    public static final CellGeometry POINT = new CellGeometry("POINT");

    /** Each cell represents an area. */
    @UML(identifier = "area", obligation = CONDITIONAL, specification = ISO_19115)
    public static final CellGeometry AREA = new CellGeometry("AREA");

    /**
     * Constructs an enum with the given name. The new enum is automatically added to the list
     * returned by {@link #values}.
     *
     * @param name The enum name. This name must not be in use by an other enum of this type.
     */
    private CellGeometry(final String name) {
        super(name, VALUES);
    }

    /**
     * Returns the list of {@code CellGeometry}s.
     *
     * @return The list of codes declared in the current JVM.
     */
    public static CellGeometry[] values() {
        synchronized (VALUES) {
            return VALUES.toArray(new CellGeometry[VALUES.size()]);
        }
    }

    /** Returns the list of enumerations of the same kind than this enum. */
    public CellGeometry[] family() {
        return values();
    }

    /**
     * Returns the CellGeometry that matches the given string, or returns a new one if none match
     * it.
     *
     * @param code The name of the code to fetch or to create.
     * @return A code matching the given name.
     */
    public static CellGeometry valueOf(String code) {
        return valueOf(CellGeometry.class, code);
    }
}
