/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2003-2005, Open Geospatial Consortium Inc.
 *
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.opengis.geometry.coordinate;

import static org.opengis.annotation.Specification.*;

import org.opengis.annotation.UML;

/**
 * Polynomial splines that use Bezier or Bernstein polynomials for interpolation purposes. An
 * <var>n</var>-long control point array shall create a polynomial curve of degree <var>n</var> that
 * defines the entire curve segment. These curves are defined in terms of a set of basis functions
 * called the Bézier or Bernstein polynomials.
 *
 * @source $URL$
 * @version <A HREF="http://www.opengeospatial.org/standards/as">ISO 19107</A>
 * @author Martin Desruisseaux (IRD)
 * @since GeoAPI 2.0
 * @todo Add equations from ISO 19107 to the javadoc.
 */
@UML(identifier = "GM_Bezier", specification = ISO_19107)
public interface Bezier extends BSplineCurve {}
