/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2003-2005, Open Geospatial Consortium Inc.
 *
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.opengis.geometry;

import static org.opengis.annotation.Obligation.*;
import static org.opengis.annotation.Specification.*;

import org.opengis.annotation.UML;
import org.opengis.geometry.complex.Complex;

/**
 * The abstract root data type for all the data types used to represent the boundary of geometric
 * objects. Any subclass of {@link Geometry} will use a subclass of {@code Boundary} to represent
 * its boundary through the operation {@link Geometry#getBoundary}. By the nature of geometry,
 * boundary objects are cycles.
 *
 * @source $URL$
 * @version <A HREF="http://www.opengeospatial.org/standards/as">ISO 19107</A>
 * @author Martin Desruisseaux (IRD)
 * @since GeoAPI 1.0
 */
@UML(identifier = "GM_Boundary", specification = ISO_19107)
public interface Boundary extends Complex {
    /**
     * Always returns {@code true} since boundary objects are cycles.
     *
     * @return Always {@code true}.
     */
    @UML(identifier = "isCycle", obligation = MANDATORY, specification = ISO_19107)
    boolean isCycle();
}
