/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.IndexManager;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShapefileFeatureSource;
import org.geotools.data.shapefile.ShapefileFeatureStore;
import org.geotools.data.shapefile.ShapefileSetManager;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.files.FileWriter;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.files.StorageFile;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.referencing.wkt.Formattable;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileDataStore
extends ContentDataStore
implements FileDataStore {
    public static final String ORIGINAL_FIELD_NAME = "original";
    public static final String ORIGINAL_FIELD_DUPLICITY_COUNT = "count";
    public static final Charset DEFAULT_STRING_CHARSET = (Charset)ShapefileDataStoreFactory.DBFCHARSET.getDefaultValue();
    public static final TimeZone DEFAULT_TIMEZONE = (TimeZone)ShapefileDataStoreFactory.DBFTIMEZONE.getDefaultValue();
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.shapefile.trace"));
    Exception trace;
    ShpFiles shpFiles;
    Charset charset = DEFAULT_STRING_CHARSET;
    TimeZone timeZone = DEFAULT_TIMEZONE;
    boolean memoryMapped = false;
    boolean bufferCachingEnabled = true;
    boolean indexed = true;
    boolean indexCreationEnabled = true;
    boolean fidIndexed = true;
    IndexManager indexManager;
    ShapefileSetManager shpManager;
    long maxShpSize = Integer.MAX_VALUE;
    long maxDbfSize = Integer.MAX_VALUE;

    public ShapefileDataStore(URL url) {
        this.shpFiles = new ShpFiles(url);
        if (TRACE_ENABLED.booleanValue()) {
            this.trace = new Exception();
            this.trace.fillInStackTrace();
        }
        this.shpManager = new ShapefileSetManager(this.shpFiles, this);
        this.indexManager = new IndexManager(this.shpFiles, this);
    }

    @Override
    protected List<Name> createTypeNames() throws IOException {
        return Collections.singletonList(this.getTypeName());
    }

    Name getTypeName() {
        return new NameImpl(this.namespaceURI, this.shpFiles.getTypeName());
    }

    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        return this.getFeatureSource();
    }

    @Override
    public ContentFeatureSource getFeatureSource() throws IOException {
        ContentEntry entry = this.ensureEntry(this.getTypeName());
        if (this.shpFiles.isWritable()) {
            return new ShapefileFeatureStore(entry, this.shpFiles);
        }
        return new ShapefileFeatureSource(entry, this.shpFiles);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isMemoryMapped() {
        return this.memoryMapped;
    }

    public void setMemoryMapped(boolean memoryMapped) {
        this.memoryMapped = memoryMapped;
    }

    public boolean isBufferCachingEnabled() {
        return this.bufferCachingEnabled;
    }

    public void setBufferCachingEnabled(boolean bufferCachingEnabled) {
        this.bufferCachingEnabled = bufferCachingEnabled;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    long getMaxShpSize() {
        return this.maxShpSize;
    }

    void setMaxShpSize(long maxShapeSize) {
        this.maxShpSize = maxShapeSize;
    }

    long getMaxDbfSize() {
        return this.maxDbfSize;
    }

    void setMaxDbfSize(long maxDbfSize) {
        this.maxDbfSize = maxDbfSize;
    }

    @Override
    public SimpleFeatureType getSchema() throws IOException {
        return this.getSchema(this.getTypeName());
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader() throws IOException {
        return super.getFeatureReader(new Query(this.getTypeName().getLocalPart()), Transaction.AUTO_COMMIT);
    }

    public long getCount(Query query) throws IOException {
        return this.getFeatureSource().getCount(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        ShapeType shapeType;
        if (!this.shpFiles.isLocal()) {
            throw new IOException("Cannot create FeatureType on remote or in-classpath shapefile");
        }
        this.shpFiles.delete();
        CoordinateReferenceSystem crs = featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
        Class geomType = featureType.getGeometryDescriptor().getType().getBinding();
        if (Point.class.isAssignableFrom(geomType)) {
            shapeType = ShapeType.POINT;
        } else if (MultiPoint.class.isAssignableFrom(geomType)) {
            shapeType = ShapeType.MULTIPOINT;
        } else if (LineString.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType)) {
            shapeType = ShapeType.ARC;
        } else if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
            shapeType = ShapeType.POLYGON;
        } else {
            throw new DataSourceException("Cannot create a shapefile whose geometry type is " + geomType);
        }
        StorageFile shpStoragefile = this.shpFiles.getStorageFile(ShpFileType.SHP);
        StorageFile shxStoragefile = this.shpFiles.getStorageFile(ShpFileType.SHX);
        StorageFile dbfStoragefile = this.shpFiles.getStorageFile(ShpFileType.DBF);
        StorageFile prjStoragefile = this.shpFiles.getStorageFile(ShpFileType.PRJ);
        FileChannel shpChannel = shpStoragefile.getWriteChannel();
        FileChannel shxChannel = shxStoragefile.getWriteChannel();
        ShapefileWriter writer = new ShapefileWriter(shpChannel, shxChannel);
        try {
            writer.writeHeaders(new Envelope(), shapeType, 0, 100);
        }
        finally {
            writer.close();
            assert (!shpChannel.isOpen());
            assert (!shxChannel.isOpen());
        }
        DbaseFileHeader dbfheader = ShapefileDataStore.createDbaseHeader(featureType);
        dbfheader.setNumRecords(0);
        try (FileChannel dbfChannel = dbfStoragefile.getWriteChannel();){
            dbfheader.writeHeader(dbfChannel);
        }
        if (crs != null) {
            String s = this.toSingleLineWKT(crs);
            try (java.io.FileWriter prjWriter = new java.io.FileWriter(prjStoragefile.getFile());){
                prjWriter.write(s);
            }
        } else {
            this.LOGGER.fine("PRJ file not generated for null CoordinateReferenceSystem");
        }
        StorageFile.replaceOriginals(shpStoragefile, shxStoragefile, dbfStoragefile, prjStoragefile);
    }

    String toSingleLineWKT(CoordinateReferenceSystem crs) {
        String wkt = null;
        try {
            Formattable formattable = (Formattable)crs;
            wkt = formattable.toWKT(0, false);
        }
        catch (ClassCastException e) {
            wkt = crs.toWKT();
        }
        wkt = wkt.replaceAll("\n", "").replaceAll("  ", "");
        return wkt;
    }

    protected static DbaseFileHeader createDbaseHeader(SimpleFeatureType featureType) throws IOException, DbaseFileException {
        DbaseFileHeader header = new DbaseFileHeader();
        int ii = featureType.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            int d;
            int l;
            AttributeDescriptor type = featureType.getDescriptor(i);
            Class colType = type.getType().getBinding();
            String colName = type.getLocalName();
            int fieldLen = FeatureTypes.getFieldLength((PropertyDescriptor)type);
            if (fieldLen == -1) {
                fieldLen = 255;
            }
            if (colType == Integer.class || colType == Short.class || colType == Byte.class) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 9), 0);
                continue;
            }
            if (colType == Long.class) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 19), 0);
                continue;
            }
            if (colType == BigInteger.class) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 33), 0);
                continue;
            }
            if (colType == Float.class) {
                l = Math.min(fieldLen, 24);
                d = Math.min(Math.max(l - 2, 0), 15);
                header.addColumn(colName, 'N', l, d);
                continue;
            }
            if (colType == Double.class) {
                l = Math.min(fieldLen, 33);
                d = Math.min(Math.max(l - 2, 0), 15);
                header.addColumn(colName, 'N', l, d);
                continue;
            }
            if (Number.class.isAssignableFrom(colType)) {
                l = Math.min(fieldLen, 33);
                d = Math.max(l - 2, 0);
                header.addColumn(colName, 'N', l, d);
                continue;
            }
            if (Date.class.isAssignableFrom(colType) && Boolean.getBoolean("org.geotools.shapefile.datetime")) {
                header.addColumn(colName, '@', fieldLen, 0);
                continue;
            }
            if (Date.class.isAssignableFrom(colType) || Calendar.class.isAssignableFrom(colType)) {
                header.addColumn(colName, 'D', fieldLen, 0);
                continue;
            }
            if (colType == Boolean.class) {
                header.addColumn(colName, 'L', 1, 0);
                continue;
            }
            if (CharSequence.class.isAssignableFrom(colType) || colType == UUID.class) {
                header.addColumn(colName, 'C', Math.min(254, fieldLen), 0);
                continue;
            }
            if (Geometry.class.isAssignableFrom(colType) || colType == byte[].class) continue;
            header.addColumn(colName, 'C', Math.min(254, fieldLen), 0);
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSchemaCRS(CoordinateReferenceSystem crs) throws IOException {
        if (crs == null) {
            throw new NullPointerException("CRS required for .prj file");
        }
        String s = this.toSingleLineWKT(crs);
        StorageFile storageFile = this.shpFiles.getStorageFile(ShpFileType.PRJ);
        try (java.io.FileWriter out = new java.io.FileWriter(storageFile.getFile());){
            out.write(s);
        }
        storageFile.replaceOriginal();
        this.entries.clear();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.shpFiles != null) {
            this.shpFiles.dispose();
            this.shpFiles = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.shpFiles != null && this.trace != null) {
            this.LOGGER.log(Level.SEVERE, "Undisposed of shapefile, you should call dispose() on all shapefile stores", this.trace);
        }
        this.dispose();
    }

    public boolean isFidIndexed() {
        return this.fidIndexed;
    }

    public void setFidIndexed(boolean fidIndexed) {
        this.fidIndexed = fidIndexed;
    }

    public String toString() {
        return "ShapefileDataStore [file=" + this.shpFiles.get(ShpFileType.SHP) + ", charset=" + this.charset + ", timeZone=" + this.timeZone + ", memoryMapped=" + this.memoryMapped + ", bufferCachingEnabled=" + this.bufferCachingEnabled + ", indexed=" + this.indexed + ", fidIndexed=" + this.fidIndexed + "]";
    }

    @Override
    public void updateSchema(SimpleFeatureType featureType) throws IOException {
        this.updateSchema(this.getTypeName().getLocalPart(), featureType);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Filter filter, Transaction transaction) throws IOException {
        return this.getFeatureWriter(this.getTypeName().getLocalPart(), filter, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Transaction transaction) throws IOException {
        return this.getFeatureWriter(this.getTypeName().getLocalPart(), transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(Transaction transaction) throws IOException {
        return this.getFeatureWriterAppend(this.getTypeName().getLocalPart(), transaction);
    }

    public boolean isIndexCreationEnabled() {
        return this.indexCreationEnabled;
    }

    public void setIndexCreationEnabled(boolean indexCreationEnabled) {
        this.indexCreationEnabled = indexCreationEnabled;
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        this.removeSchema(new NameImpl(null, typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSchema(Name typeName) throws IOException {
        ContentEntry entry = this.ensureEntry(typeName);
        FileWriter writer = new FileWriter(){

            @Override
            public String id() {
                return "TheShapefileRemover";
            }
        };
        for (ShpFileType type : ShpFileType.values()) {
            File file = this.shpFiles.acquireWriteFile(type, writer);
            try {
                if (!file.exists() || file.delete()) continue;
                throw new IOException("Failed to delete " + file.getAbsolutePath());
            }
            finally {
                this.shpFiles.unlockWrite(file, writer);
            }
        }
        this.removeEntry(entry.getName());
    }
}

