/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import org.geotools.geometry.jts.coordinatesequence.CSBuilder;

public class DefaultCSBuilder
implements CSBuilder {
    private Coordinate[] coordinateArray;
    private CoordinateSequenceFactory factory = DefaultCoordinateSequenceFactory.instance();

    @Override
    public void start(int size, int dimensions) {
        this.coordinateArray = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            this.coordinateArray[i] = new Coordinate();
        }
    }

    @Override
    public CoordinateSequence end() {
        CoordinateSequence cs = this.factory.create(this.coordinateArray);
        this.coordinateArray = null;
        return cs;
    }

    @Override
    public void setOrdinate(double value, int ordinateIndex, int coordinateIndex) {
        Coordinate c = this.coordinateArray[coordinateIndex];
        switch (ordinateIndex) {
            case 0: {
                c.x = value;
                break;
            }
            case 1: {
                c.y = value;
                break;
            }
            case 2: {
                c.z = value;
            }
        }
    }

    @Override
    public double getOrdinate(int ordinateIndex, int coordinateIndex) {
        Coordinate c = this.coordinateArray[coordinateIndex];
        switch (ordinateIndex) {
            case 0: {
                return c.x;
            }
            case 1: {
                return c.y;
            }
            case 2: {
                return c.z;
            }
        }
        return 0.0;
    }

    @Override
    public int getSize() {
        if (this.coordinateArray != null) {
            return this.coordinateArray.length;
        }
        return -1;
    }

    @Override
    public int getDimension() {
        if (this.coordinateArray != null) {
            return 2;
        }
        return -1;
    }

    @Override
    public void setOrdinate(CoordinateSequence sequence, double value, int ordinateIndex, int coordinateIndex) {
        Coordinate c = sequence.getCoordinate(coordinateIndex);
        switch (ordinateIndex) {
            case 0: {
                c.x = value;
                break;
            }
            case 1: {
                c.y = value;
                break;
            }
            case 2: {
                c.z = value;
            }
        }
    }
}

