/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.spatial.AbstractPreparedGeometryFilter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Disjoint;

public class DisjointImpl
extends AbstractPreparedGeometryFilter
implements Disjoint {
    public DisjointImpl(Expression e1, Expression e2) {
        super(e1, e2);
    }

    public DisjointImpl(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2, matchAction);
    }

    @Override
    public boolean evaluateInternal(Geometry left, Geometry right) {
        switch (this.literals) {
            case BOTH: {
                return this.cacheValue;
            }
            case RIGHT: {
                return this.rightPreppedGeom.disjoint(left);
            }
            case LEFT: {
                return this.leftPreppedGeom.disjoint(right);
            }
        }
        return this.basicEvaluate(left, right);
    }

    @Override
    protected boolean basicEvaluate(Geometry left, Geometry right) {
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envRight.intersects(envLeft)) {
            return left.disjoint(right);
        }
        return true;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Disjoint)this, extraData);
    }
}

