/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;

public class LogicSAXParser {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private FilterFactory2 ff;
    private short logicType = (short)-1;
    private List<Filter> subFilters = new ArrayList<Filter>();
    private LogicSAXParser logicFactory = null;
    private boolean isComplete = false;

    public LogicSAXParser() {
        this(CommonFactoryFinder.getFilterFactory2());
    }

    public LogicSAXParser(FilterFactory2 factory) {
        this.ff = factory;
        LOGGER.finer("made new logic factory");
    }

    public void setFilterFactory(FilterFactory2 factory) {
        this.ff = factory;
    }

    public void start(short logicType) throws IllegalFilterException {
        LOGGER.finest("got a start element: " + logicType);
        if (this.logicType != -1) {
            if (this.logicFactory == null) {
                this.logicFactory = new LogicSAXParser();
            }
            this.logicFactory.start(logicType);
        } else {
            if (!AbstractFilter.isLogicFilter(logicType)) {
                throw new IllegalFilterException("Add logic filter type does not match declared type.");
            }
            this.logicType = logicType;
        }
    }

    public void end(short logicType) throws IllegalFilterException {
        LOGGER.finer("got an end element: " + logicType);
        if (this.logicFactory != null) {
            LOGGER.finer("sending end element to nested logic filter: " + logicType);
            this.logicFactory.end(logicType);
            if (this.logicFactory.isComplete()) {
                this.subFilters.add(this.logicFactory.create());
                this.logicFactory = null;
            }
        } else if (this.logicType == logicType) {
            LOGGER.finer("end element matched internal type: " + this.logicType);
            this.isComplete = true;
        } else {
            throw new IllegalFilterException("Logic Factory got an end message that it can't process.");
        }
    }

    public void add(Filter filter) {
        LOGGER.finer("added a filter: " + filter.toString());
        if (this.logicFactory != null) {
            LOGGER.finer("adding to nested logic filter: " + filter.toString());
            this.logicFactory.add(filter);
        } else {
            LOGGER.finer("added to sub filters: " + filter.toString());
            this.subFilters.add(filter);
        }
    }

    public Filter create() throws IllegalFilterException {
        Not filter = null;
        LOGGER.finer("creating a logic filter");
        if (this.isComplete()) {
            LOGGER.finer("filter is complete, with type: " + this.logicType);
            if (this.logicType == 3) {
                filter = this.ff.not(this.subFilters.get(0));
            } else if (this.logicType == 2) {
                filter = this.ff.and(this.subFilters);
            } else if (this.logicType == 1) {
                filter = this.ff.or(this.subFilters);
            }
            this.subFilters = new ArrayList<Filter>();
            this.logicType = (short)-1;
            this.isComplete = false;
            return filter;
        }
        throw new IllegalFilterException("Attempted to generate incomplete logic filter.");
    }

    public boolean isComplete() {
        return this.isComplete;
    }
}

