/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.geotools.data.ows.Request;

public abstract class AbstractRequest
implements Request {
    public static final String EXCEPTION_XML = "application/vnd.ogc.se_xml";
    protected URL onlineResource;
    protected Properties properties;
    protected Map<String, Object> hints;

    public AbstractRequest(URL onlineResource, Properties properties) {
        this.properties = properties == null ? new Properties() : properties;
        int index = onlineResource.toExternalForm().lastIndexOf("?");
        String urlWithoutQuery = null;
        if (index <= 0) {
            urlWithoutQuery = onlineResource.toExternalForm();
            if (!AbstractRequest.isFileUrl(onlineResource)) {
                urlWithoutQuery = urlWithoutQuery + "?";
            }
        } else {
            urlWithoutQuery = onlineResource.toExternalForm().substring(0, index);
            boolean once = true;
            if (onlineResource.getQuery() != null) {
                StringTokenizer tokenizer = new StringTokenizer(onlineResource.getQuery(), "&");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    String[] param = token.split("=");
                    if (param == null || param.length <= 0 || param[0] == null) continue;
                    String key = param[0];
                    if (param.length == 1) {
                        if (once) {
                            urlWithoutQuery = urlWithoutQuery + "?" + param[0] + "&";
                            once = false;
                            continue;
                        }
                        urlWithoutQuery = urlWithoutQuery + param[0] + "&";
                        continue;
                    }
                    String value = param[1];
                    this.setProperty(key.toUpperCase(), value);
                }
            }
            if (once) {
                urlWithoutQuery = urlWithoutQuery + "?";
            }
        }
        try {
            this.onlineResource = new URL(urlWithoutQuery);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error parsing URL. This is likely a bug in the code.");
        }
        this.initService();
        this.initRequest();
        this.initVersion();
    }

    static boolean isFileUrl(URL url) {
        return url.getProtocol().equalsIgnoreCase("file");
    }

    @Override
    public URL getFinalURL() {
        if (AbstractRequest.isFileUrl(this.onlineResource)) {
            return this.onlineResource;
        }
        String url = this.onlineResource.toExternalForm();
        if (!url.contains("?")) {
            url = url.concat("?");
        }
        Iterator<Map.Entry<Object, Object>> iter = this.properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String value = (String)entry.getValue();
            String param = this.processKey((String)entry.getKey());
            if (value != null && param.length() != 0) {
                param = param + "=" + value;
            }
            if (iter.hasNext()) {
                param = param.concat("&");
            }
            url = url.concat(param);
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String processKey(String key) {
        return key;
    }

    @Override
    public void setProperty(String name, String value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.setProperty(name, value);
        }
    }

    @Override
    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    protected abstract void initRequest();

    protected abstract void initService();

    protected abstract void initVersion();

    @Override
    public String getPostContentType() {
        return "application/xml";
    }

    @Override
    public void performPostOutput(OutputStream outputStream) throws IOException {
    }

    @Override
    public boolean requiresPost() {
        return false;
    }

    @Override
    public Map<String, Object> getRequestHints() {
        return this.hints == null ? Collections.emptyMap() : this.hints;
    }

    @Override
    public void setRequestHints(Map<String, Object> hints) {
        this.hints = hints;
    }
}

