/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.AuthorityFactoryProxy;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

public class IdentifiedObjectFinder {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.referencing.factory.finder");
    private AuthorityFactoryProxy proxy;
    private boolean fullScan = true;

    protected IdentifiedObjectFinder() {
    }

    IdentifiedObjectFinder(IdentifiedObjectFinder finder) {
        this.setProxy(finder.getProxy());
    }

    protected IdentifiedObjectFinder(AuthorityFactory factory, Class type) {
        this.setProxy(AuthorityFactoryProxy.getInstance(factory, type));
    }

    protected AuthorityFactoryProxy getProxy() {
        return this.proxy;
    }

    public boolean isFullScanAllowed() {
        return this.fullScan;
    }

    public void setFullScanAllowed(boolean fullScan) {
        this.fullScan = fullScan;
    }

    public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
        IdentifiedObject candidate = this.createFromIdentifiers(object);
        if (candidate != null) {
            return candidate;
        }
        candidate = this.createFromNames(object);
        if (candidate != null) {
            return candidate;
        }
        candidate = this.createFromCodes(object, true);
        if (candidate != null) {
            return candidate;
        }
        return this.fullScan ? this.createFromCodes(object, false) : null;
    }

    public String findIdentifier(IdentifiedObject object) throws FactoryException {
        IdentifiedObject candidate = this.find(object);
        return candidate != null ? this.getIdentifier(candidate) : null;
    }

    protected Citation getAuthority() {
        return this.getProxy().getAuthorityFactory().getAuthority();
    }

    final String getIdentifier(IdentifiedObject object) {
        ReferenceIdentifier identifier;
        Citation authority = this.getAuthority();
        if (ReferencingFactory.ALL.equals(authority)) {
            authority = null;
        }
        if ((identifier = AbstractIdentifiedObject.getIdentifier(object, authority)) == null) {
            identifier = object.getName();
        }
        String codespace = identifier.getCodeSpace();
        String code = identifier.getCode();
        if (codespace != null) {
            return codespace + ':' + code;
        }
        return code;
    }

    final IdentifiedObject createFromIdentifiers(IdentifiedObject object) throws FactoryException {
        Citation authority = this.getProxy().getAuthorityFactory().getAuthority();
        boolean isAll = ReferencingFactory.ALL.equals(authority);
        for (Identifier id : object.getIdentifiers()) {
            IdentifiedObject candidate;
            if (!isAll && !Citations.identifierMatches((Citation)authority, (Citation)id.getAuthority())) continue;
            try {
                candidate = this.getProxy().create(id.getCode());
            }
            catch (NoSuchAuthorityCodeException e) {
                continue;
            }
            if ((candidate = this.deriveEquivalent(candidate, object)) == null) continue;
            return candidate;
        }
        return null;
    }

    final IdentifiedObject createFromNames(IdentifiedObject object) throws FactoryException {
        IdentifiedObject candidate;
        try {
            candidate = this.getProxy().create(object.getName().getCode());
            candidate = this.deriveEquivalent(candidate, object);
            if (candidate != null) {
                return candidate;
            }
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        for (GenericName id : object.getAlias()) {
            try {
                candidate = this.getProxy().create(id.toString());
            }
            catch (FactoryException e) {
                continue;
            }
            if ((candidate = this.deriveEquivalent(candidate, object)) == null) continue;
            return candidate;
        }
        return null;
    }

    final IdentifiedObject createFromCodes(IdentifiedObject object, boolean specific) throws FactoryException {
        Set codes = specific ? this.getSpecificCodeCandidates(object) : this.getCodeCandidates(object);
        for (String code : codes) {
            IdentifiedObject candidate;
            try {
                candidate = this.getProxy().create(code);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.FINEST, "Could not create '" + code + "':" + (Object)((Object)e));
                continue;
            }
            catch (Exception problemCode) {
                LOGGER.log(Level.FINEST, "Could not create '" + code + "':" + problemCode, problemCode);
                continue;
            }
            if ((candidate = this.deriveEquivalent(candidate, object)) == null) continue;
            return candidate;
        }
        return null;
    }

    protected Set getSpecificCodeCandidates(IdentifiedObject object) throws FactoryException {
        return Collections.emptySet();
    }

    protected Set getCodeCandidates(IdentifiedObject object) throws FactoryException {
        return this.getProxy().getAuthorityCodes();
    }

    protected IdentifiedObject deriveEquivalent(IdentifiedObject candidate, IdentifiedObject model) throws FactoryException {
        return CRS.equalsIgnoreMetadata(candidate, model) ? candidate : null;
    }

    public String toString() {
        return this.getProxy().toString(IdentifiedObjectFinder.class);
    }

    public void setProxy(AuthorityFactoryProxy proxy) {
        this.proxy = proxy;
    }

    static class Adapter
    extends IdentifiedObjectFinder {
        protected final IdentifiedObjectFinder finder;

        protected Adapter(IdentifiedObjectFinder finder) {
            super(finder);
            this.finder = finder;
        }

        @Override
        public void setFullScanAllowed(boolean fullScan) {
            this.finder.setFullScanAllowed(fullScan);
            super.setFullScanAllowed(fullScan);
        }

        @Override
        protected Set getCodeCandidates(IdentifiedObject object) throws FactoryException {
            return this.finder.getCodeCandidates(object);
        }

        @Override
        protected Set getSpecificCodeCandidates(IdentifiedObject object) throws FactoryException {
            return this.finder.getSpecificCodeCandidates(object);
        }

        @Override
        protected IdentifiedObject deriveEquivalent(IdentifiedObject candidate, IdentifiedObject model) throws FactoryException {
            return this.finder.deriveEquivalent(candidate, model);
        }
    }
}

