/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import org.openstreetmap.josm.spi.preferences.Config;

public class Preferences {
    protected static int GuiCode;
    private static String prefix;

    public static String getLoadDir() {
        return Config.getPref().get(String.valueOf(prefix) + "loadDir");
    }

    public static void setLoadDir(String loadDir) {
        Config.getPref().put(String.valueOf(prefix) + "loadDir", loadDir);
    }

    public static GuiMode getGuiMode() {
        int GuiCode = Config.getPref().getInt(String.valueOf(prefix) + "guiCode", 0);
        switch (GuiCode) {
            case -1: 
            case 1: {
                return GuiMode.Expert;
            }
            case 2: {
                return GuiMode.Simple;
            }
        }
        if (Config.getPref().getBoolean("expert")) {
            return GuiMode.Expert;
        }
        return GuiMode.Simple;
    }

    public static boolean isLegacyActions() {
        return Config.getPref().getInt(String.valueOf(prefix) + "guiCode", 0) == -1;
    }

    public static boolean isMergeNodes() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "mergeNodes");
    }

    public static double getMergeNodesValue() {
        return Config.getPref().getDouble(String.valueOf(prefix) + "mergeNodes.value", 0.001);
    }

    public static boolean isRemoveSmall() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "removeSmall");
    }

    public static double getRemoveSmallValue() {
        return Config.getPref().getDouble(String.valueOf(prefix) + "removeSmall.value", 1.0);
    }

    public static boolean isRemoveLarge() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "removeLarge");
    }

    public static double getRemoveLargeValue() {
        return Config.getPref().getDouble(String.valueOf(prefix) + "removeLarge.value", 10.0);
    }

    public static boolean isRemoveParallel() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "removeParallel");
    }

    public static double getRemoveParallelValue() {
        return Config.getPref().getDouble(String.valueOf(prefix) + "removeParallel.value", 3.0);
    }

    public static boolean isLimitPath() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "limitPath");
    }

    public static int getLimitPathValue() {
        return Config.getPref().getInt(String.valueOf(prefix) + "limitPath.value", Integer.MAX_VALUE);
    }

    public static boolean isLimitColor() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "limitColor");
    }

    public static String getLimitColorValue() {
        return Config.getPref().get(String.valueOf(prefix) + "limitColor.value", "#000000");
    }

    public static boolean isDebugTags() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "debugTags");
    }

    public static boolean isLayerClosed() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "layerClosed");
    }

    public static boolean isLayerSegment() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "layerSegment");
    }

    public static boolean isLayerAttribChange() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "layerAttribChanges");
    }

    public static boolean isLayerOrtho() {
        return Config.getPref().getBoolean(String.valueOf(prefix) + "layerOrtho");
    }

    private Preferences() {
    }

    public Preferences(String p) {
        prefix = String.valueOf(p) + ".";
    }

    public static enum GuiMode {
        Auto,
        Expert,
        Simple;

    }
}

