/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDAppearanceDictionary
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(PDAppearanceDictionary.class);
    private COSDictionary dictionary;

    public PDAppearanceDictionary() {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.N, (COSBase)new COSDictionary());
    }

    public PDAppearanceDictionary(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public Map<String, PDAppearanceStream> getNormalAppearance() {
        COSBase ap = this.dictionary.getDictionaryObject(COSName.N);
        if (ap == null) {
            return null;
        }
        if (ap instanceof COSStream) {
            COSStream aux = (COSStream)ap;
            ap = new COSDictionary();
            ((COSDictionary)ap).setItem(COSName.DEFAULT, (COSBase)aux);
        }
        COSDictionary map = (COSDictionary)ap;
        HashMap<String, PDAppearanceStream> actuals = new HashMap<String, PDAppearanceStream>();
        COSDictionaryMap<String, PDAppearanceStream> retval = new COSDictionaryMap<String, PDAppearanceStream>(actuals, map);
        for (COSName asName : map.keySet()) {
            COSBase stream = map.getDictionaryObject(asName);
            if (stream instanceof COSStream) {
                COSStream as = (COSStream)stream;
                actuals.put(asName.getName(), new PDAppearanceStream(as));
                continue;
            }
            LOG.debug((Object)"non-conformance workaround: ignore null value for appearance stream.");
        }
        return retval;
    }

    public void setNormalAppearance(Map<String, PDAppearanceStream> appearanceMap) {
        this.dictionary.setItem(COSName.N, (COSBase)COSDictionaryMap.convert(appearanceMap));
    }

    public void setNormalAppearance(PDAppearanceStream ap) {
        this.dictionary.setItem(COSName.N, (COSBase)ap.getStream());
    }

    public Map<String, PDAppearanceStream> getRolloverAppearance() {
        Map<String, PDAppearanceStream> retval = null;
        COSBase ap = this.dictionary.getDictionaryObject(COSName.R);
        if (ap == null) {
            retval = this.getNormalAppearance();
        } else {
            if (ap instanceof COSStream) {
                COSStream aux = (COSStream)ap;
                ap = new COSDictionary();
                ((COSDictionary)ap).setItem(COSName.DEFAULT, (COSBase)aux);
            }
            COSDictionary map = (COSDictionary)ap;
            HashMap<String, PDAppearanceStream> actuals = new HashMap<String, PDAppearanceStream>();
            retval = new COSDictionaryMap<String, PDAppearanceStream>(actuals, map);
            for (COSName asName : map.keySet()) {
                COSBase stream = map.getDictionaryObject(asName);
                if (stream instanceof COSStream) {
                    COSStream as = (COSStream)stream;
                    actuals.put(asName.getName(), new PDAppearanceStream(as));
                    continue;
                }
                LOG.debug((Object)"non-conformance workaround: ignore null value for appearance stream.");
            }
        }
        return retval;
    }

    public void setRolloverAppearance(Map<String, PDAppearanceStream> appearanceMap) {
        this.dictionary.setItem(COSName.R, (COSBase)COSDictionaryMap.convert(appearanceMap));
    }

    public void setRolloverAppearance(PDAppearanceStream ap) {
        this.dictionary.setItem(COSName.R, (COSBase)ap.getStream());
    }

    public Map<String, PDAppearanceStream> getDownAppearance() {
        Map<String, PDAppearanceStream> retval = null;
        COSBase ap = this.dictionary.getDictionaryObject(COSName.D);
        if (ap == null) {
            retval = this.getNormalAppearance();
        } else {
            if (ap instanceof COSStream) {
                COSStream aux = (COSStream)ap;
                ap = new COSDictionary();
                ((COSDictionary)ap).setItem(COSName.DEFAULT, (COSBase)aux);
            }
            COSDictionary map = (COSDictionary)ap;
            HashMap<String, PDAppearanceStream> actuals = new HashMap<String, PDAppearanceStream>();
            retval = new COSDictionaryMap<String, PDAppearanceStream>(actuals, map);
            for (COSName asName : map.keySet()) {
                COSBase stream = map.getDictionaryObject(asName);
                if (stream instanceof COSStream) {
                    COSStream as = (COSStream)stream;
                    actuals.put(asName.getName(), new PDAppearanceStream(as));
                    continue;
                }
                LOG.debug((Object)"non-conformance workaround: ignore null value for appearance stream.");
            }
        }
        return retval;
    }

    public void setDownAppearance(Map<String, PDAppearanceStream> appearanceMap) {
        this.dictionary.setItem(COSName.D, (COSBase)COSDictionaryMap.convert(appearanceMap));
    }

    public void setDownAppearance(PDAppearanceStream ap) {
        this.dictionary.setItem(COSName.D, (COSBase)ap.getStream());
    }
}

