/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationShrinker
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final PartialEvaluator simplePartialEvaluator = new PartialEvaluator();
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true);
    private final MyUnusedParameterSimplifier unusedParameterSimplifier = new MyUnusedParameterSimplifier();
    private final MyProducerMarker producerMarker = new MyProducerMarker();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false);
    private boolean[][] variablesNecessaryAfter = new boolean[1024][64];
    private boolean[][] stacksNecessaryAfter = new boolean[1024][16];
    private boolean[][] stacksSimplifiedBefore = new boolean[1024][16];
    private boolean[] instructionsNecessary = new boolean[1024];
    private int maxMarkedOffset;

    public EvaluationShrinker() {
        this(new PartialEvaluator(), null, null);
    }

    public EvaluationShrinker(PartialEvaluator partialEvaluator, InstructionVisitor instructionVisitor, InstructionVisitor instructionVisitor2) {
        this.partialEvaluator = partialEvaluator;
        this.extraDeletedInstructionVisitor = instructionVisitor;
        this.extraAddedInstructionVisitor = instructionVisitor2;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while shrinking instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        Instruction instruction2;
        int n;
        int n2;
        this.initializeNecessary(codeAttribute);
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int n3 = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.partialEvaluator.isTraced(n2)) continue;
            Instruction instruction3 = InstructionFactory.create(codeAttribute.code, n2);
            instruction3.accept(clazz, method, codeAttribute, n2, this.unusedParameterSimplifier);
        }
        this.maxMarkedOffset = -1;
        n2 = this.partialEvaluator.superInitializationOffset();
        if (n2 != -2) {
            this.markInstruction(n2);
        }
        for (n = 0; n < n3; ++n) {
            if (!this.partialEvaluator.isTraced(n)) continue;
            instruction2 = InstructionFactory.create(codeAttribute.code, n);
            if (instruction2.opcode == -89 && ((BranchInstruction)instruction2).branchOffset == 0) {
                this.markInstruction(n);
                continue;
            }
            if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, instruction2)) continue;
            this.markInstruction(n);
        }
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n)) continue;
            if (this.isInstructionNecessary(n)) {
                instruction2 = InstructionFactory.create(codeAttribute.code, n);
                instruction2.accept(clazz, method, codeAttribute, n, this.producerMarker);
            }
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
        for (n = 0; n < n3; ++n) {
            int n4;
            if (!this.partialEvaluator.isTraced(n) || this.isInstructionNecessary(n) || (n4 = this.partialEvaluator.initializedVariable(n)) < 0 || !this.isVariableInitializationNecessary(clazz, method, codeAttribute, n, n4)) continue;
            this.markInstruction(n);
        }
        this.maxMarkedOffset = n3 - 1;
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n)) continue;
            Instruction instruction4 = InstructionFactory.create(codeAttribute.code, n);
            instruction4.accept(clazz, method, codeAttribute, n, this.stackConsistencyFixer);
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
        for (n = 0; n < n3; ++n) {
            if (!this.partialEvaluator.isTraced(n) || this.isInstructionNecessary(n) || !this.isAllSmallerThanOrEqual(this.partialEvaluator.branchTargets(n), n) || this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(n), n)) continue;
            this.replaceByInfiniteLoop(clazz, n);
        }
        for (n = 0; n < n3; ++n) {
            Instruction instruction5;
            int n5;
            if (!this.isInstructionNecessary(n) || !this.partialEvaluator.isSubroutineInvocation(n) || this.isInstructionNecessary(n5 = n + (instruction5 = InstructionFactory.create(codeAttribute.code, n)).length(n))) continue;
            this.replaceByInfiniteLoop(clazz, n5);
        }
        n = 0;
        do {
            instruction = InstructionFactory.create(codeAttribute.code, n);
            if (this.isInstructionNecessary(n)) continue;
            this.codeAttributeEditor.deleteInstruction(n);
            this.codeAttributeEditor.insertBeforeInstruction(n, (Instruction)null);
            this.codeAttributeEditor.replaceInstruction(n, (Instruction)null);
            this.codeAttributeEditor.insertAfterInstruction(n, (Instruction)null);
            if (this.extraDeletedInstructionVisitor == null) continue;
            instruction.accept(clazz, method, codeAttribute, n, this.extraDeletedInstructionVisitor);
        } while ((n += instruction.length(n)) < n3);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private void markVariableProducers(int n, int n2) {
        TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
        this.markVariableProducers(tracedVariables.getProducerValue(n2).instructionOffsetValue(), n2);
    }

    private void markVariableProducers(InstructionOffsetValue instructionOffsetValue, int n) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                this.markVariableAfter(n3, n);
                this.markInstruction(n3);
            }
        }
    }

    private void markStackProducers(Clazz clazz, int n, Instruction instruction) {
        int n2 = instruction.stackPopCount(clazz);
        for (int i = 0; i < n2; ++i) {
            this.markStackEntryProducers(n, i);
        }
    }

    private void conditionallyMarkStackEntryProducers(int n, int n2, int n3) {
        int n4 = this.partialEvaluator.getStackAfter(n).size() - 1;
        if (this.isStackEntryNecessaryAfter(n, n4 - n2)) {
            this.markStackEntryProducers(n, n3);
        }
    }

    private void markStackEntryProducers(int n, int n2) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        int n3 = tracedStack.size() - 1 - n2;
        if (!this.isStackSimplifiedBefore(n, n3)) {
            this.markStackEntryProducers(tracedStack.getTopProducerValue(n2).instructionOffsetValue(), n3);
        }
    }

    private void markStackEntryProducers(InstructionOffsetValue instructionOffsetValue, int n) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                this.markStackEntryAfter(n3, n);
                this.markInstruction(n3);
            }
        }
    }

    private void markInitialization(int n) {
        int n2 = this.partialEvaluator.initializationOffset(n);
        TracedStack tracedStack = this.partialEvaluator.getStackAfter(n);
        this.markStackEntryAfter(n2, tracedStack.size() - 1);
        this.markInstruction(n2);
    }

    private void markStraddlingBranches(int n, InstructionOffsetValue instructionOffsetValue, boolean bl) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                if (bl) {
                    this.markStraddlingBranch(n, n3, n, n3);
                    continue;
                }
                this.markStraddlingBranch(n, n3, n3, n);
            }
        }
    }

    private void markStraddlingBranch(int n, int n2, int n3, int n4) {
        if (!this.isInstructionNecessary(n3) && this.isAnyInstructionNecessary(n, n2)) {
            this.markInstruction(n3);
        }
    }

    private void fixDupInstruction(Clazz clazz, CodeAttribute codeAttribute, int n, Instruction instruction) {
        int n2 = this.partialEvaluator.getStackAfter(n).size() - 1;
        int n3 = instruction.opcode;
        int n4 = 0;
        switch (n3) {
            case 89: {
                boolean bl = this.isStackEntryNecessaryAfter(n, n2 - 0);
                boolean bl2 = this.isStackEntryNecessaryAfter(n, n2 - 1);
                if (!bl && !bl2 || !bl || !bl2) break;
                n4 = 89;
                break;
            }
            case 90: {
                int n5;
                boolean bl = this.isStackEntryNecessaryAfter(n, n2 - 0);
                boolean bl3 = this.isStackEntryNecessaryAfter(n, n2 - 1);
                boolean bl4 = this.isStackEntryNecessaryAfter(n, n2 - 2);
                if (!bl && !bl4 || !bl4) break;
                int n6 = n5 = bl3 ? 1 : 0;
                if (bl) {
                    n4 = (byte)(89 + n5);
                    break;
                }
                if (n5 != 1) break;
                n4 = 95;
                break;
            }
            case 91: {
                boolean bl = this.isStackEntryNecessaryAfter(n, n2 - 0);
                boolean bl5 = this.isStackEntryNecessaryAfter(n, n2 - 1);
                boolean bl6 = this.isStackEntryNecessaryAfter(n, n2 - 2);
                boolean bl7 = this.isStackEntryNecessaryAfter(n, n2 - 3);
                if (!bl && !bl7 || !bl7) break;
                int n7 = (bl5 ? 1 : 0) + (bl6 ? 1 : 0);
                if (bl) {
                    n4 = (byte)(89 + n7);
                    break;
                }
                if (n7 == 1) {
                    n4 = 95;
                    break;
                }
                if (n7 != 2) break;
                throw new UnsupportedOperationException("Can't handle dup_x2 instruction moving original element across two elements at [" + n + "]");
            }
            case 92: {
                boolean bl = this.isStackEntriesNecessaryAfter(n, n2 - 0, n2 - 1);
                boolean bl8 = this.isStackEntriesNecessaryAfter(n, n2 - 2, n2 - 3);
                if (!bl && !bl8 || !bl || !bl8) break;
                n4 = 92;
                break;
            }
            case 93: {
                int n8;
                boolean bl = this.isStackEntriesNecessaryAfter(n, n2 - 0, n2 - 1);
                boolean bl9 = this.isStackEntryNecessaryAfter(n, n2 - 2);
                boolean bl10 = this.isStackEntriesNecessaryAfter(n, n2 - 3, n2 - 4);
                if (!bl && !bl10 || !bl10) break;
                int n9 = n8 = bl9 ? 1 : 0;
                if (bl) {
                    n4 = (byte)(92 + n8);
                    break;
                }
                if (n8 <= 0) break;
                throw new UnsupportedOperationException("Can't handle dup2_x1 instruction moving original element across " + n8 + " elements at [" + n + "]");
            }
            case 94: {
                boolean bl = this.isStackEntriesNecessaryAfter(n, n2 - 0, n2 - 1);
                boolean bl11 = this.isStackEntryNecessaryAfter(n, n2 - 2);
                boolean bl12 = this.isStackEntryNecessaryAfter(n, n2 - 3);
                boolean bl13 = this.isStackEntriesNecessaryAfter(n, n2 - 4, n2 - 5);
                if (!bl && !bl13 || !bl13) break;
                int n10 = (bl11 ? 1 : 0) + (bl12 ? 1 : 0);
                if (bl) {
                    n4 = (byte)(92 + n10);
                    break;
                }
                if (n10 <= 0) break;
                throw new UnsupportedOperationException("Can't handle dup2_x2 instruction moving original element across " + n10 + " elements at [" + n + "]");
            }
            case 95: {
                boolean bl = this.isStackEntryNecessaryAfter(n, n2 - 0);
                boolean bl14 = this.isStackEntryNecessaryAfter(n, n2 - 1);
                if (!bl && !bl14 || !bl || !bl14) break;
                n4 = 95;
            }
        }
        if (n4 == 0) {
            this.codeAttributeEditor.deleteInstruction(n);
            if (this.extraDeletedInstructionVisitor != null) {
                this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, n, null);
            }
        } else if (n4 == n3) {
            this.codeAttributeEditor.undeleteInstruction(n);
        } else {
            SimpleInstruction simpleInstruction = new SimpleInstruction((byte)n4);
            this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
        }
    }

    private void insertPushInstructions(int n, boolean bl, int n2) {
        this.markInstruction(n);
        SimpleInstruction simpleInstruction = new SimpleInstruction(this.pushOpcode(n2));
        if (bl) {
            this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
        } else {
            this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
            }
        }
    }

    private byte pushOpcode(int n) {
        switch (n) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + n + "]");
    }

    private void insertPopInstructions(int n, boolean bl, int n2) {
        this.markInstruction(n);
        switch (n2) {
            case 1: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(87);
                if (bl) {
                    this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
                    break;
                }
                this.codeAttributeEditor.insertAfterInstruction(n, simpleInstruction);
                if (this.extraAddedInstructionVisitor == null) break;
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
                break;
            }
            case 2: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                if (bl) {
                    this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
                    break;
                }
                this.codeAttributeEditor.insertAfterInstruction(n, simpleInstruction);
                if (this.extraAddedInstructionVisitor == null) break;
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
                break;
            }
            default: {
                int n3;
                Instruction[] instructionArray = new Instruction[n2 / 2 + n2 % 2];
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                for (n3 = 0; n3 < n2 / 2; ++n3) {
                    instructionArray[n3] = simpleInstruction;
                }
                if (n2 % 2 == 1) {
                    simpleInstruction = new SimpleInstruction(87);
                    instructionArray[n2 / 2] = simpleInstruction;
                }
                if (bl) {
                    this.codeAttributeEditor.replaceInstruction(n, instructionArray);
                    for (n3 = 1; n3 < instructionArray.length; ++n3) {
                        if (this.extraAddedInstructionVisitor == null) continue;
                        instructionArray[n3].accept(null, null, null, n, this.extraAddedInstructionVisitor);
                    }
                } else {
                    this.codeAttributeEditor.insertAfterInstruction(n, instructionArray);
                    for (n3 = 0; n3 < instructionArray.length; ++n3) {
                        if (this.extraAddedInstructionVisitor == null) continue;
                        instructionArray[n3].accept(null, null, null, n, this.extraAddedInstructionVisitor);
                    }
                }
                break;
            }
        }
    }

    private void replaceByStaticInvocation(Clazz clazz, int n, ConstantInstruction constantInstruction) {
        Instruction instruction = new ConstantInstruction(-72, constantInstruction.constantIndex).shrink();
        this.codeAttributeEditor.replaceInstruction(n, instruction);
    }

    private void replaceByInfiniteLoop(Clazz clazz, int n) {
        this.markInstruction(n);
        BranchInstruction branchInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(n, branchInstruction);
    }

    private boolean isDupOrSwap(Instruction instruction) {
        return instruction.opcode >= 89 && instruction.opcode <= 95;
    }

    private boolean isPop(Instruction instruction) {
        return instruction.opcode == 87 || instruction.opcode == 88;
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.partialEvaluator.isTraced(i) || this.isInstructionNecessary(i) || !this.isAnyLargerThan(this.partialEvaluator.branchTargets(i), n2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2;
        if (instructionOffsetValue != null && (n2 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.instructionOffset(i) <= n) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2;
        if (instructionOffsetValue != null && (n2 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.instructionOffset(i) <= n) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeNecessary(CodeAttribute codeAttribute) {
        int n;
        int n2;
        int n3 = codeAttribute.u4codeLength;
        int n4 = codeAttribute.u2maxLocals;
        int n5 = codeAttribute.u2maxStack;
        if (this.variablesNecessaryAfter.length < n3 || this.variablesNecessaryAfter[0].length < n4) {
            this.variablesNecessaryAfter = new boolean[n3][n4];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    this.variablesNecessaryAfter[n2][n] = false;
                }
            }
        }
        if (this.stacksNecessaryAfter.length < n3 || this.stacksNecessaryAfter[0].length < n5) {
            this.stacksNecessaryAfter = new boolean[n3][n5];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n5; ++n) {
                    this.stacksNecessaryAfter[n2][n] = false;
                }
            }
        }
        if (this.stacksSimplifiedBefore.length < n3 || this.stacksSimplifiedBefore[0].length < n5) {
            this.stacksSimplifiedBefore = new boolean[n3][n5];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n5; ++n) {
                    this.stacksSimplifiedBefore[n2][n] = false;
                }
            }
        }
        if (this.instructionsNecessary.length < n3) {
            this.instructionsNecessary = new boolean[n3];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                this.instructionsNecessary[n2] = false;
            }
        }
    }

    private boolean isStackEntriesNecessaryAfter(int n, int n2, int n3) {
        boolean bl = this.isStackEntryNecessaryAfter(n, n2);
        boolean bl2 = this.isStackEntryNecessaryAfter(n, n3);
        return bl || bl2;
    }

    private boolean isVariableInitializationNecessary(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        int n3 = codeAttribute.u4codeLength;
        if (this.isVariableNecessaryAfterAny(0, n3, n2)) {
            this.simplePartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            for (int i = 0; i < n3; ++i) {
                Value value;
                Value value2;
                if (!this.partialEvaluator.isTraced(i) || (value2 = this.partialEvaluator.getVariablesBefore(i).getProducerValue(n2)) == null || (value = this.simplePartialEvaluator.getVariablesBefore(i).getProducerValue(n2)) == null) continue;
                InstructionOffsetValue instructionOffsetValue = value2.instructionOffsetValue();
                InstructionOffsetValue instructionOffsetValue2 = value.instructionOffsetValue();
                if (!this.isVariableNecessaryAfterAny(instructionOffsetValue, n2) || this.isVariableNecessaryAfterAll(instructionOffsetValue2, n2)) continue;
                return true;
            }
        }
        return false;
    }

    private void markVariableAfter(int n, int n2) {
        if (!this.isVariableNecessaryAfter(n, n2)) {
            this.variablesNecessaryAfter[n][n2] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isVariableNecessaryAfterAny(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            if (!this.isVariableNecessaryAfter(i, n3)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryAfterAny(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2 = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isVariableNecessaryAfter(instructionOffsetValue.instructionOffset(i), n)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryAfterAll(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2 = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n2; ++i) {
            if (this.isVariableNecessaryAfter(instructionOffsetValue.instructionOffset(i), n)) continue;
            return false;
        }
        return true;
    }

    private boolean isVariableNecessaryAfter(int n, int n2) {
        return n == -1 || this.variablesNecessaryAfter[n][n2];
    }

    private void markStackEntryAfter(int n, int n2) {
        if (!this.isStackEntryNecessaryAfter(n, n2)) {
            this.stacksNecessaryAfter[n][n2] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isAnyStackEntryNecessaryAfter(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2 = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isStackEntryNecessaryAfter(instructionOffsetValue.instructionOffset(i), n)) continue;
            return true;
        }
        return false;
    }

    private boolean isStackEntryNecessaryAfter(int n, int n2) {
        return n == -1 || this.stacksNecessaryAfter[n][n2];
    }

    private void markStackSimplificationBefore(int n, int n2) {
        this.stacksSimplifiedBefore[n][n2] = true;
    }

    private boolean isStackSimplifiedBefore(int n, int n2) {
        return this.stacksSimplifiedBefore[n][n2];
    }

    private void markInstruction(int n) {
        if (!this.isInstructionNecessary(n)) {
            this.instructionsNecessary[n] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isAnyInstructionNecessary(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isInstructionNecessary(i)) continue;
            return true;
        }
        return false;
    }

    private int lastNecessaryInstructionOffset(int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!this.isInstructionNecessary(n)) continue;
            return i;
        }
        return 0;
    }

    private boolean isInstructionNecessary(int n) {
        return n == -1 || this.instructionsNecessary[n];
    }

    private class MyStackConsistencyFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            if (EvaluationShrinker.this.isInstructionNecessary(n)) {
                int n2;
                int n3;
                int n4;
                int n5 = instruction.stackPopCount(clazz);
                if (n5 > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(n);
                    int n6 = tracedStack.size() - 1;
                    n4 = 0;
                    for (n3 = 0; n3 < n5; ++n3) {
                        if (EvaluationShrinker.this.isStackSimplifiedBefore(n, n6 - n3) || EvaluationShrinker.this.isAnyStackEntryNecessaryAfter(tracedStack.getTopProducerValue(n3).instructionOffsetValue(), n6 - n3)) continue;
                        ++n4;
                    }
                    if (n4 > 0) {
                        if (n4 > (instruction.isCategory2() ? 2 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + n4 + "]");
                        }
                        EvaluationShrinker.this.insertPushInstructions(n, false, tracedStack.getTop(0).computationalType());
                    }
                }
                if ((n2 = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackAfter(n);
                    n4 = tracedStack.size() - 1;
                    n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        if (EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n4 - i)) continue;
                        ++n3;
                    }
                    if (n3 > 0) {
                        EvaluationShrinker.this.insertPopInstructions(n, false, n3);
                    }
                }
            } else {
                int n7;
                int n8;
                int n9;
                int n10 = instruction.stackPopCount(clazz);
                if (n10 > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(n);
                    int n11 = tracedStack.size() - 1;
                    n9 = 0;
                    for (n8 = 0; n8 < n10; ++n8) {
                        if (!EvaluationShrinker.this.isAnyStackEntryNecessaryAfter(tracedStack.getTopProducerValue(n8).instructionOffsetValue(), n11 - n8)) continue;
                        ++n9;
                    }
                    if (n9 > 0) {
                        EvaluationShrinker.this.insertPopInstructions(n, true, n9);
                    }
                }
                if ((n7 = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackAfter(n);
                    n9 = tracedStack.size() - 1;
                    n8 = 0;
                    for (int i = 0; i < n7; ++i) {
                        if (!EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n9 - i)) continue;
                        ++n8;
                    }
                    if (n8 > 0) {
                        EvaluationShrinker.this.insertPushInstructions(n, true, tracedStack.getTop(0).computationalType());
                    }
                }
            }
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            if (EvaluationShrinker.this.isInstructionNecessary(n) && EvaluationShrinker.this.isDupOrSwap(simpleInstruction)) {
                EvaluationShrinker.this.fixDupInstruction(clazz, codeAttribute, n, simpleInstruction);
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, n, simpleInstruction);
            }
        }
    }

    private class MyProducerMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyProducerMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            EvaluationShrinker.this.markStackProducers(clazz, n, instruction);
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 89: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 0);
                    break;
                }
                case 90: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 0);
                    break;
                }
                case 91: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 3, 0);
                    break;
                }
                case 92: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 3, 1);
                    break;
                }
                case 93: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 3, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 4, 1);
                    break;
                }
                case 94: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 3, 3);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 4, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 5, 1);
                    break;
                }
                case 95: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 0);
                    break;
                }
                default: {
                    EvaluationShrinker.this.markStackProducers(clazz, n, simpleInstruction);
                }
            }
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode < 54) {
                EvaluationShrinker.this.markVariableProducers(n, variableInstruction.variableIndex);
            } else {
                EvaluationShrinker.this.markStackProducers(clazz, n, variableInstruction);
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            if (constantInstruction.opcode == -69) {
                EvaluationShrinker.this.markInitialization(n);
            }
            EvaluationShrinker.this.markStackProducers(clazz, n, constantInstruction);
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -88 || branchInstruction.opcode == -55) {
                EvaluationShrinker.this.markStackEntryAfter(n, 0);
            } else {
                EvaluationShrinker.this.markStackProducers(clazz, n, branchInstruction);
            }
        }
    }

    private class MyUnusedParameterSimplifier
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyUnusedParameterSimplifier() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    this.invocationOffset = n;
                    this.invocationInstruction = constantInstruction;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                }
            }
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept(this);
        }

        public void visitAnyMember(Clazz clazz, Member member) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            int n = ParameterUsageMarker.getParameterSize(programMethod);
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed(programMethod, 0)) {
                EvaluationShrinker.this.replaceByStaticInvocation(programClass, this.invocationOffset, this.invocationInstruction);
            }
            for (int i = 0; i < n; ++i) {
                if (ParameterUsageMarker.isParameterUsed(programMethod, i)) continue;
                TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(this.invocationOffset);
                int n2 = tracedStack.size() - n + i;
                EvaluationShrinker.this.markStackSimplificationBefore(this.invocationOffset, n2);
            }
        }
    }
}

