/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ExceptionHandlerFilter;
import proguard.evaluation.BasicBranchUnit;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Processor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.TracedBranchUnit;
import proguard.optimize.peephole.BranchTargetFinder;

public class PartialEvaluator
extends SimplifiedVisitor
implements AttributeVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final int MAXIMUM_EVALUATION_COUNT = 5;
    public static final int NONE = -2;
    public static final int AT_METHOD_ENTRY = -1;
    public static final int AT_CATCH_ENTRY = -1;
    private final ValueFactory valueFactory;
    private final InvocationUnit invocationUnit;
    private final boolean evaluateAllCode;
    private InstructionOffsetValue[] branchOriginValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] branchTargetValues = new InstructionOffsetValue[1024];
    private TracedVariables[] variablesBefore = new TracedVariables[1024];
    private TracedStack[] stacksBefore = new TracedStack[1024];
    private TracedVariables[] variablesAfter = new TracedVariables[1024];
    private TracedStack[] stacksAfter = new TracedStack[1024];
    private boolean[] generalizedContexts = new boolean[1024];
    private int[] evaluationCounts = new int[1024];
    private int[] initializedVariables = new int[1024];
    private boolean evaluateExceptions;
    private final BasicBranchUnit branchUnit;
    private final BranchTargetFinder branchTargetFinder;
    private final Stack callingInstructionBlockStack;
    private final Stack instructionBlockStack = new Stack();

    public PartialEvaluator() {
        this(new ValueFactory(), new BasicInvocationUnit(new ValueFactory()), true);
    }

    public PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean bl) {
        this(valueFactory, invocationUnit, bl, bl ? new BasicBranchUnit() : new TracedBranchUnit(), new BranchTargetFinder(), null);
    }

    private PartialEvaluator(PartialEvaluator partialEvaluator) {
        this(partialEvaluator.valueFactory, partialEvaluator.invocationUnit, partialEvaluator.evaluateAllCode, partialEvaluator.branchUnit, partialEvaluator.branchTargetFinder, partialEvaluator.instructionBlockStack);
    }

    private PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean bl, BasicBranchUnit basicBranchUnit, BranchTargetFinder branchTargetFinder, Stack stack) {
        this.valueFactory = valueFactory;
        this.invocationUnit = invocationUnit;
        this.evaluateAllCode = bl;
        this.branchUnit = basicBranchUnit;
        this.branchTargetFinder = branchTargetFinder;
        this.callingInstructionBlockStack = stack == null ? this.instructionBlockStack : stack;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            Instruction instruction;
            System.err.println("Unexpected error while performing partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            method.accept(clazz, new ClassPrinter());
            System.out.println("Evaluation results:");
            int n = 0;
            do {
                InstructionOffsetValue instructionOffsetValue;
                int n2;
                if (this.isBranchOrExceptionTarget(n)) {
                    System.out.println("Branch target from [" + this.branchOriginValues[n] + "]:");
                    if (this.isTraced(n)) {
                        System.out.println("  Vars:  " + this.variablesBefore[n]);
                        System.out.println("  Stack: " + this.stacksBefore[n]);
                    }
                }
                instruction = InstructionFactory.create(codeAttribute.code, n);
                System.out.println(instruction.toString(n));
                if (!this.isTraced(n)) continue;
                int n3 = this.initializedVariable(n);
                if (n3 >= 0) {
                    System.out.println("     is initializing variable v" + n3);
                }
                if ((n2 = this.branchTargetFinder.initializationOffset(n)) != -2) {
                    System.out.println("     is to be initialized at [" + n2 + "]");
                }
                if ((instructionOffsetValue = this.branchTargets(n)) != null) {
                    System.out.println("     has overall been branching to " + instructionOffsetValue);
                }
                System.out.println("  Vars:  " + this.variablesAfter[n]);
                System.out.println("  Stack: " + this.stacksAfter[n]);
            } while ((n += instruction.length(n)) < codeAttribute.u4codeLength);
            throw runtimeException;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        TracedVariables tracedVariables = new TracedVariables(codeAttribute.u2maxLocals);
        TracedStack tracedStack = new TracedStack(codeAttribute.u2maxStack);
        this.initializeVariables(clazz, method, codeAttribute, tracedVariables, tracedStack);
        codeAttribute.accept(clazz, method, (AttributeVisitor)this.branchTargetFinder);
        this.evaluateInstructionBlockAndExceptionHandlers(clazz, method, codeAttribute, tracedVariables, tracedStack, 0, codeAttribute.u4codeLength);
    }

    public boolean isTraced(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isTraced(int n) {
        return this.evaluationCounts[n] > 0;
    }

    public boolean isInstruction(int n) {
        return this.branchTargetFinder.isInstruction(n);
    }

    public boolean isBranchOrExceptionTarget(int n) {
        return this.branchTargetFinder.isBranchTarget(n) || this.branchTargetFinder.isExceptionHandler(n);
    }

    public boolean isSubroutineStart(int n) {
        return this.branchTargetFinder.isSubroutineStart(n);
    }

    public boolean isSubroutineInvocation(int n) {
        return this.branchTargetFinder.isSubroutineInvocation(n);
    }

    public boolean isSubroutine(int n) {
        return this.branchTargetFinder.isSubroutine(n);
    }

    public boolean isSubroutineReturning(int n) {
        return this.branchTargetFinder.isSubroutineReturning(n);
    }

    public int subroutineEnd(int n) {
        return this.branchTargetFinder.subroutineEnd(n);
    }

    public int initializationOffset(int n) {
        return this.branchTargetFinder.initializationOffset(n);
    }

    public boolean isInitializer() {
        return this.branchTargetFinder.isInitializer();
    }

    public int superInitializationOffset() {
        return this.branchTargetFinder.superInitializationOffset();
    }

    public int creationOffset(int n) {
        return this.branchTargetFinder.creationOffset(n);
    }

    public TracedVariables getVariablesBefore(int n) {
        return this.variablesBefore[n];
    }

    public TracedVariables getVariablesAfter(int n) {
        return this.variablesAfter[n];
    }

    public TracedStack getStackBefore(int n) {
        return this.stacksBefore[n];
    }

    public TracedStack getStackAfter(int n) {
        return this.stacksAfter[n];
    }

    public InstructionOffsetValue branchOrigins(int n) {
        return this.branchOriginValues[n];
    }

    public InstructionOffsetValue branchTargets(int n) {
        return this.branchTargetValues[n];
    }

    public int initializedVariable(int n) {
        return this.initializedVariables[n];
    }

    private void pushCallingInstructionBlock(TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        this.callingInstructionBlockStack.push(new MyInstructionBlock(tracedVariables, tracedStack, n));
    }

    private void pushInstructionBlock(TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        this.instructionBlockStack.push(new MyInstructionBlock(tracedVariables, tracedStack, n));
    }

    private void evaluateInstructionBlockAndExceptionHandlers(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n, int n2) {
        this.evaluateInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, n);
        this.evaluateExceptionHandlers(clazz, method, codeAttribute, n, n2);
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        this.evaluateSingleInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, n);
        while (!this.instructionBlockStack.empty()) {
            MyInstructionBlock myInstructionBlock = (MyInstructionBlock)this.instructionBlockStack.pop();
            this.evaluateSingleInstructionBlock(clazz, method, codeAttribute, myInstructionBlock.variables, myInstructionBlock.stack, myInstructionBlock.startOffset);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void evaluateSingleInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n) {
        Instruction instruction;
        byte[] byArray = codeAttribute.code;
        Processor processor = new Processor(tracedVariables, tracedStack, this.valueFactory, this.branchUnit, this.invocationUnit);
        int n2 = n;
        int n3 = n;
        do {
            int n4;
            if (n3 < n2) {
                n3 = n2;
            }
            if ((n4 = this.evaluationCounts[n2]) == 0) {
                if (this.variablesBefore[n2] == null) {
                    this.variablesBefore[n2] = new TracedVariables(tracedVariables);
                    this.stacksBefore[n2] = new TracedStack(tracedStack);
                } else {
                    this.variablesBefore[n2].initialize(tracedVariables);
                    this.stacksBefore[n2].copy(tracedStack);
                }
                this.generalizedContexts[n2] = true;
            } else {
                boolean bl = this.variablesBefore[n2].generalize(tracedVariables, true);
                boolean bl2 = this.stacksBefore[n2].generalize(tracedStack);
                if (!bl && !bl2 && this.generalizedContexts[n2]) {
                    return;
                }
                if (n4 >= 5) {
                    tracedVariables.generalize(this.variablesBefore[n2], false);
                    tracedStack.generalize(this.stacksBefore[n2]);
                    this.generalizedContexts[n2] = true;
                } else {
                    this.generalizedContexts[n2] = false;
                }
            }
            int n5 = n2;
            this.evaluationCounts[n5] = this.evaluationCounts[n5] + 1;
            InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(n2);
            tracedVariables.setProducerValue(instructionOffsetValue);
            tracedStack.setProducerValue(instructionOffsetValue);
            InstructionOffsetValue instructionOffsetValue2 = InstructionOffsetValue.EMPTY_VALUE;
            tracedVariables.resetInitialization();
            instruction = InstructionFactory.create(byArray, n2);
            int n6 = n2 + instruction.length(n2);
            InstructionOffsetValue instructionOffsetValue3 = new InstructionOffsetValue(n6);
            this.branchUnit.resetCalled();
            this.branchUnit.setTraceBranchTargets(instructionOffsetValue3);
            try {
                instruction.accept(clazz, method, codeAttribute, n2, processor);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Unexpected error while evaluating instruction:");
                System.err.println("  Class       = [" + clazz.getName() + "]");
                System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
                System.err.println("  Instruction = " + instruction.toString(n2));
                System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
                throw runtimeException;
            }
            this.initializedVariables[n2] = tracedVariables.getInitializationIndex();
            InstructionOffsetValue instructionOffsetValue4 = this.branchUnit.getTraceBranchTargets();
            int n7 = instructionOffsetValue4.instructionOffsetCount();
            this.branchUnit.setTraceBranchTargets(instructionOffsetValue2);
            if (n4 == 0) {
                if (this.variablesAfter[n2] == null) {
                    this.variablesAfter[n2] = new TracedVariables(tracedVariables);
                    this.stacksAfter[n2] = new TracedStack(tracedStack);
                } else {
                    this.variablesAfter[n2].initialize(tracedVariables);
                    this.stacksAfter[n2].copy(tracedStack);
                }
            } else {
                this.variablesAfter[n2].generalize(tracedVariables, true);
                this.stacksAfter[n2].generalize(tracedStack);
            }
            if (this.branchUnit.wasCalled()) {
                int n8;
                InstructionOffsetValue instructionOffsetValue5 = this.branchTargetValues[n2] = this.branchTargetValues[n2] == null ? instructionOffsetValue4 : this.branchTargetValues[n2].generalize(instructionOffsetValue4).instructionOffsetValue();
                if (n7 == 0) {
                    return;
                }
                InstructionOffsetValue instructionOffsetValue6 = new InstructionOffsetValue(n2);
                for (n8 = 0; n8 < n7; ++n8) {
                    int n9 = instructionOffsetValue4.instructionOffset(n8);
                    this.branchOriginValues[n9] = this.branchOriginValues[n9] == null ? instructionOffsetValue6 : this.branchOriginValues[n9].generalize(instructionOffsetValue6).instructionOffsetValue();
                }
                if (n7 > 1) {
                    n8 = 0;
                    while (n8 < n7) {
                        this.pushInstructionBlock(new TracedVariables(tracedVariables), new TracedStack(tracedStack), instructionOffsetValue4.instructionOffset(n8));
                        ++n8;
                    }
                    return;
                }
            }
            n2 = instructionOffsetValue4.instructionOffset(0);
            if (instruction.opcode != -88 && instruction.opcode != -55) continue;
            this.evaluateSubroutine(clazz, method, codeAttribute, tracedVariables, tracedStack, n2, this.instructionBlockStack);
            return;
        } while (instruction.opcode != -87);
        this.pushCallingInstructionBlock(new TracedVariables(tracedVariables), new TracedStack(tracedStack), n2);
    }

    private void evaluateSubroutine(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack, int n, Stack stack) {
        int n2 = this.branchTargetFinder.subroutineEnd(n);
        PartialEvaluator partialEvaluator = this;
        if (this.evaluationCounts[n] > 0) {
            partialEvaluator = new PartialEvaluator(this);
            partialEvaluator.initializeVariables(clazz, method, codeAttribute, tracedVariables, tracedStack);
        }
        partialEvaluator.evaluateInstructionBlockAndExceptionHandlers(clazz, method, codeAttribute, tracedVariables, tracedStack, n, n2);
        if (partialEvaluator != this) {
            this.generalize(partialEvaluator, 0, codeAttribute.u4codeLength);
        }
    }

    private void generalize(PartialEvaluator partialEvaluator, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (partialEvaluator.branchOriginValues[i] != null) {
                InstructionOffsetValue instructionOffsetValue = this.branchOriginValues[i] = this.branchOriginValues[i] == null ? partialEvaluator.branchOriginValues[i] : this.branchOriginValues[i].generalize(partialEvaluator.branchOriginValues[i]).instructionOffsetValue();
            }
            if (!partialEvaluator.isTraced(i)) continue;
            if (partialEvaluator.branchTargetValues[i] != null) {
                InstructionOffsetValue instructionOffsetValue = this.branchTargetValues[i] = this.branchTargetValues[i] == null ? partialEvaluator.branchTargetValues[i] : this.branchTargetValues[i].generalize(partialEvaluator.branchTargetValues[i]).instructionOffsetValue();
            }
            if (this.evaluationCounts[i] == 0) {
                this.variablesBefore[i] = partialEvaluator.variablesBefore[i];
                this.stacksBefore[i] = partialEvaluator.stacksBefore[i];
                this.variablesAfter[i] = partialEvaluator.variablesAfter[i];
                this.stacksAfter[i] = partialEvaluator.stacksAfter[i];
                this.generalizedContexts[i] = partialEvaluator.generalizedContexts[i];
                this.evaluationCounts[i] = partialEvaluator.evaluationCounts[i];
                this.initializedVariables[i] = partialEvaluator.initializedVariables[i];
                continue;
            }
            this.variablesBefore[i].generalize(partialEvaluator.variablesBefore[i], false);
            this.stacksBefore[i].generalize(partialEvaluator.stacksBefore[i]);
            this.variablesAfter[i].generalize(partialEvaluator.variablesAfter[i], false);
            this.stacksAfter[i].generalize(partialEvaluator.stacksAfter[i]);
            int n3 = i;
            this.evaluationCounts[n3] = this.evaluationCounts[n3] + partialEvaluator.evaluationCounts[i];
        }
    }

    private void evaluateExceptionHandlers(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2) {
        ExceptionHandlerFilter exceptionHandlerFilter = new ExceptionHandlerFilter(n, n2, this);
        do {
            this.evaluateExceptions = false;
            codeAttribute.exceptionsAccept(clazz, method, n, n2, exceptionHandlerFilter);
        } while (this.evaluateExceptions);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int n = exceptionInfo.u2startPC;
        int n2 = exceptionInfo.u2endPC;
        if (this.isTraced(n, n2)) {
            int n3 = exceptionInfo.u2handlerPC;
            int n4 = exceptionInfo.u2catchType;
            TracedVariables tracedVariables = new TracedVariables(codeAttribute.u2maxLocals);
            TracedStack tracedStack = new TracedStack(codeAttribute.u2maxStack);
            InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(-1);
            tracedVariables.setProducerValue(instructionOffsetValue);
            tracedStack.setProducerValue(instructionOffsetValue);
            this.generalizeVariables(n, n2, this.evaluateAllCode, tracedVariables);
            String string = n4 != 0 ? clazz.getClassName(n4) : "java/lang/Throwable";
            Clazz clazz2 = n4 != 0 ? ((ClassConstant)((ProgramClass)clazz).getConstant((int)n4)).referencedClass : null;
            tracedStack.push(this.valueFactory.createReferenceValue(string, clazz2, false));
            int n5 = this.evaluationCounts[n3];
            this.evaluateInstructionBlock(clazz, method, codeAttribute, tracedVariables, tracedStack, n3);
            if (!this.evaluateExceptions) {
                this.evaluateExceptions = n5 < this.evaluationCounts[n3];
            }
        }
    }

    private void initializeVariables(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables tracedVariables, TracedStack tracedStack) {
        int n;
        int n2 = codeAttribute.u4codeLength;
        if (this.variablesAfter.length < n2) {
            this.branchOriginValues = new InstructionOffsetValue[n2];
            this.branchTargetValues = new InstructionOffsetValue[n2];
            this.variablesBefore = new TracedVariables[n2];
            this.stacksBefore = new TracedStack[n2];
            this.variablesAfter = new TracedVariables[n2];
            this.stacksAfter = new TracedStack[n2];
            this.generalizedContexts = new boolean[n2];
            this.evaluationCounts = new int[n2];
            this.initializedVariables = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.initializedVariables[n] = -2;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.branchOriginValues[n] = null;
                this.branchTargetValues[n] = null;
                this.generalizedContexts[n] = false;
                this.evaluationCounts[n] = 0;
                this.initializedVariables[n] = -2;
                if (this.variablesBefore[n] != null) {
                    this.variablesBefore[n].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksBefore[n] != null) {
                    this.stacksBefore[n].reset(codeAttribute.u2maxStack);
                }
                if (this.variablesAfter[n] != null) {
                    this.variablesAfter[n].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksAfter[n] == null) continue;
                this.stacksAfter[n].reset(codeAttribute.u2maxStack);
            }
        }
        TracedVariables tracedVariables2 = new TracedVariables(codeAttribute.u2maxLocals);
        InstructionOffsetValue instructionOffsetValue = new InstructionOffsetValue(-1);
        tracedVariables2.setProducerValue(instructionOffsetValue);
        this.invocationUnit.enterMethod(clazz, method, tracedVariables2);
        tracedVariables.initialize(tracedVariables2);
        InstructionOffsetValue instructionOffsetValue2 = new InstructionOffsetValue(-1);
        for (int i = 0; i < tracedVariables2.size(); ++i) {
            tracedVariables.setProducerValue(i, instructionOffsetValue2);
        }
    }

    private void generalizeVariables(int n, int n2, boolean bl, TracedVariables tracedVariables) {
        boolean bl2 = true;
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            TracedVariables tracedVariables2 = this.variablesBefore[i];
            if (bl2) {
                tracedVariables.initialize(tracedVariables2);
                bl2 = false;
            } else {
                tracedVariables.generalize(tracedVariables2, false);
            }
            n3 = i;
        }
        if (bl && n3 >= 0) {
            TracedVariables tracedVariables3 = this.variablesAfter[n3];
            if (bl2) {
                tracedVariables.initialize(tracedVariables3);
            } else {
                tracedVariables.generalize(tracedVariables3, false);
            }
        }
        if (bl2) {
            tracedVariables.reset(tracedVariables.size());
        }
    }

    private static class MyInstructionBlock {
        private TracedVariables variables;
        private TracedStack stack;
        private int startOffset;

        private MyInstructionBlock(TracedVariables tracedVariables, TracedStack tracedStack, int n) {
            this.variables = tracedVariables;
            this.stack = tracedStack;
            this.startOffset = n;
        }
    }
}

