/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmarender;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Utils;

public class OsmarenderPlugin
extends Plugin {
    private JMenuItem osmarenderMenu;

    public OsmarenderPlugin(PluginInformation info) throws IOException {
        super(info);
        this.osmarenderMenu = MainMenu.add((JMenu)MainApplication.getMenu().viewMenu, (JosmAction)new Action());
        this.osmarenderMenu.setVisible(false);
        this._copy("/osmarender.xsl", "osmarender.xsl");
        this._copy("/osm-map-features.xml", "osm-map-features.xml");
    }

    @Deprecated
    public String _getPluginDir() {
        return new File(Main.pref.getPluginsDirectory(), this.getPluginInformation().name).getPath();
    }

    @Deprecated
    public void _copy(String from, String to) throws IOException {
        String pluginDirName = this._getPluginDir();
        File pluginDir = new File(pluginDirName);
        if (!pluginDir.exists()) {
            Utils.mkDirs((File)pluginDir);
        }
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(from);){
            if (in == null) {
                throw new IOException("Resource not found: " + from);
            }
            Files.copy(in, new File(pluginDirName, to).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame != null && newFrame == null) {
            this.osmarenderMenu.setVisible(false);
        } else if (oldFrame == null && newFrame != null) {
            this.osmarenderMenu.setVisible(true);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new OsmarenderPreferenceSetting();
    }

    private void writeGenerated(Bounds b) throws IOException {
        String boundsTag = "<bounds minlat=\"" + b.getMin().lat() + "\" maxlat=\"" + b.getMax().lat() + "\" minlon=\"" + b.getMin().lon() + "\" maxlon=\"" + b.getMax().lon() + "\" />";
        String pluginDir = this.getPluginDirs().getUserDataDirectory(false).getPath();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pluginDir + File.separator + "osm-map-features.xml"), StandardCharsets.UTF_8));
             PrintWriter writer = new PrintWriter(pluginDir + File.separator + "generated.xml", "UTF-8");){
            String str;
            while ((str = reader.readLine()) != null) {
                if (str.contains("<!--bounds_mkr1-->")) {
                    writer.println(str);
                    writer.println("    " + boundsTag);
                    while (!str.contains("<!--bounds_mkr2-->")) {
                        str = reader.readLine();
                    }
                    writer.println(str);
                    continue;
                }
                writer.println(str);
            }
        }
    }

    private static class OsmarenderPreferenceSetting
    implements SubPreferenceSetting {
        private JTextField firefox = new JTextField(10);

        private OsmarenderPreferenceSetting() {
        }

        public void addGui(PreferenceTabbedPane gui) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            panel.add((Component)new JLabel(I18n.tr((String)"Firefox executable", (Object[])new Object[0])), GBC.std().insets(10, 5, 5, 0));
            panel.add((Component)this.firefox, GBC.eol().insets(0, 5, 0, 0).fill(2));
            panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
            this.firefox.setText(Main.pref.get("osmarender.firefox"));
            gui.getMapPreference().getTabPane().addTab(I18n.tr((String)"Osmarender", (Object[])new Object[0]), panel);
        }

        public boolean ok() {
            Main.pref.put("osmarender.firefox", this.firefox.getText());
            return false;
        }

        public boolean isExpert() {
            return false;
        }

        public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
            return gui.getMapPreference();
        }
    }

    private class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr((String)"Osmarender", (Object[])new Object[0]), (String)null, I18n.tr((String)"Osmarender", (Object[])new Object[0]), null, true, "osmarender", true);
        }

        public void actionPerformed(ActionEvent e) {
            DataSet ds = MainApplication.getLayerManager().getEditDataSet();
            if (ds == null) {
                return;
            }
            MapView mapView = MainApplication.getMap().mapView;
            LatLon bottomLeft = mapView.getLatLon(0, mapView.getHeight());
            LatLon topRight = mapView.getLatLon(mapView.getWidth(), 0);
            Bounds b = new Bounds(bottomLeft, topRight);
            try {
                OsmarenderPlugin.this.writeGenerated(b);
            }
            catch (IOException ex) {
                Logging.error((Throwable)ex);
            }
            String firefox = Main.pref.get("osmarender.firefox", "firefox");
            String pluginDir = OsmarenderPlugin.this.getPluginDirs().getUserDataDirectory(false).getPath();
            try (OsmWriter w = OsmWriterFactory.createOsmWriter((PrintWriter)new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pluginDir + File.separator + "data.osm"), "UTF-8")), (boolean)false, (String)"0.6");){
                w.header();
                HashSet<Node> parents = new HashSet<Node>();
                for (Node node : ds.getNodes()) {
                    if (!node.isUsable() || node.getCoor() == null || !node.getCoor().isWithin(b)) continue;
                    parents.addAll(node.getReferrers());
                    w.visit((INode)node);
                }
                for (OsmPrimitive osmPrimitive : new HashSet(parents)) {
                    if (!(osmPrimitive instanceof Way)) continue;
                    for (Node n : ((Way)osmPrimitive).getNodes()) {
                        if (n.getCoor() == null || !n.getCoor().isWithin(b)) continue;
                        parents.add(n);
                    }
                }
                for (OsmPrimitive osmPrimitive : parents) {
                    if (!(osmPrimitive instanceof Way)) continue;
                    w.visit((IWay)((Way)osmPrimitive));
                }
                for (OsmPrimitive osmPrimitive : parents) {
                    if (!(osmPrimitive instanceof Relation)) continue;
                    w.visit((IRelation)((Relation)osmPrimitive));
                }
                w.footer();
                w.close();
                String argument = Main.platform instanceof PlatformHookWindows ? "file:///" + pluginDir.replace('\\', '/').replace(" ", "%20") + File.separator + "generated.xml\"" : pluginDir + File.separator + "generated.xml";
                Runtime.getRuntime().exec(new String[]{firefox, argument});
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Firefox not found. Please set firefox executable in the Map Settings page of the preferences.", (Object[])new Object[0]));
            }
        }
    }
}

