/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffIIOMetadataDecoder;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.data.DataSourceException;
import org.geotools.data.MapInfoFileReader;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;

public class GeoTiffFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(GeoTiffFormat.class);
    public static final DefaultParameterDescriptor<Boolean> WRITE_TFW = new DefaultParameterDescriptor<Boolean>("WRITE_TFW", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.FALSE);
    public static final DefaultParameterDescriptor<Boolean> RETAIN_AXES_ORDER = new DefaultParameterDescriptor<Boolean>("RETAIN_AXES_ORDER", Boolean.class, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, Boolean.FALSE);
    static final TIFFImageWriterSpi IMAGEIO_WRITER_FACTORY = new TIFFImageWriterSpi();
    private static final TIFFImageReaderSpi IMAGEIO_READER_FACTORY = new TIFFImageReaderSpi();

    public GeoTiffFormat() {
        this.writeParameters = null;
        this.mInfo = new HashMap();
        this.mInfo.put("name", "GeoTIFF");
        this.mInfo.put("description", "Tagged Image File Format with Geographic information");
        this.mInfo.put("vendor", "Geotools");
        this.mInfo.put("version", "1.1");
        this.mInfo.put("docURL", "http://www.remotesensing.org/geotiff/spec/geotiffhome.html");
        this.readParameters = new ParameterGroup(new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, SUGGESTED_TILE_SIZE}));
        this.writeParameters = new ParameterGroup(new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{RETAIN_AXES_ORDER, AbstractGridFormat.GEOTOOLS_WRITE_PARAMS, AbstractGridFormat.PROGRESS_LISTENER}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean accepts(Object o, Hints hints) {
        boolean bl;
        boolean closeMe;
        ImageInputStream inputStream;
        ImageReader reader;
        block77: {
            block75: {
                boolean bl2;
                block76: {
                    GeoTiffIIOMetadataDecoder metadataAdapter;
                    block73: {
                        boolean mif2333333332;
                        block74: {
                            MapInfoFileReader mif2333333332;
                            block71: {
                                boolean bl3;
                                block72: {
                                    IIOMetadata metadata;
                                    block69: {
                                        boolean bl4;
                                        block70: {
                                            block67: {
                                                boolean url222222222222222222;
                                                block68: {
                                                    block65: {
                                                        boolean url222222222222222222;
                                                        block66: {
                                                            if (o == null) {
                                                                return false;
                                                            }
                                                            reader = null;
                                                            inputStream = null;
                                                            closeMe = true;
                                                            if (o instanceof URL) {
                                                                URL url222222222222222222 = (URL)o;
                                                                o = URLs.urlToFile(url222222222222222222);
                                                            } else if (o instanceof ImageInputStream) {
                                                                closeMe = false;
                                                            }
                                                            inputStream = (ImageInputStream)(o instanceof ImageInputStream ? o : ImageIO.createImageInputStream(o));
                                                            if (inputStream != null) break block65;
                                                            if (LOGGER.isLoggable(Level.FINE)) {
                                                                LOGGER.fine("Unable to get an ImageInputStream");
                                                            }
                                                            url222222222222222222 = false;
                                                            if (reader == null) break block66;
                                                            try {
                                                                reader.dispose();
                                                            }
                                                            catch (Exception exception) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (closeMe && inputStream != null) {
                                                            try {
                                                                inputStream.close();
                                                            }
                                                            catch (Throwable throwable) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        return url222222222222222222;
                                                    }
                                                    if (IMAGEIO_READER_FACTORY.canDecodeInput(inputStream)) break block67;
                                                    url222222222222222222 = false;
                                                    if (reader == null) break block68;
                                                    try {
                                                        reader.dispose();
                                                    }
                                                    catch (Exception exception) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (closeMe && inputStream != null) {
                                                    try {
                                                        inputStream.close();
                                                    }
                                                    catch (Throwable throwable) {
                                                        // empty catch block
                                                    }
                                                }
                                                return url222222222222222222;
                                            }
                                            reader = IMAGEIO_READER_FACTORY.createReaderInstance();
                                            inputStream.mark();
                                            reader.setInput(inputStream);
                                            metadata = reader.getImageMetadata(0);
                                            if (metadata != null) break block69;
                                            bl4 = false;
                                            if (reader == null) break block70;
                                            try {
                                                reader.dispose();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        if (closeMe && inputStream != null) {
                                            try {
                                                inputStream.close();
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                        return bl4;
                                    }
                                    metadataAdapter = new GeoTiffIIOMetadataDecoder(metadata);
                                    if (!metadataAdapter.hasGeoKey() && LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Unable to find geokey directory for this tif file");
                                    }
                                    if (!metadataAdapter.hasModelTrasformation() && (!metadataAdapter.hasPixelScales() || !metadataAdapter.hasTiePoints())) break block71;
                                    bl3 = true;
                                    if (reader == null) break block72;
                                    try {
                                        reader.dispose();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (closeMe && inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                return bl3;
                            }
                            MathTransform raster2Model = GeoTiffReader.parseWorldFile(o);
                            if (raster2Model == null && (mif2333333332 = GeoTiffReader.parseMapInfoFile(o)) != null) {
                                raster2Model = mif2333333332.getTransform();
                            }
                            if (raster2Model == null) break block73;
                            mif2333333332 = true;
                            if (reader == null) break block74;
                            try {
                                reader.dispose();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (closeMe && inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return mif2333333332;
                    }
                    TiePoint[] modelTiePoints = metadataAdapter.getModelTiePoints();
                    if (modelTiePoints == null || modelTiePoints.length <= 1) break block75;
                    bl2 = true;
                    if (reader == null) break block76;
                    try {
                        reader.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (closeMe && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to find georeferencing for this tif file");
            }
            bl = false;
            if (reader == null) break block77;
            try {
                reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (closeMe && inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
        catch (Throwable e) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                boolean bl5 = false;
                return bl5;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.dispose();
                    }
                    catch (Exception exception) {}
                }
                if (closeMe && inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    @Override
    public GeoTiffReader getReader(Object source) {
        return this.getReader(source, null);
    }

    @Override
    public GeoTiffReader getReader(Object source, Hints hints) {
        if (source instanceof URL) {
            URL url = (URL)source;
            try {
                File file = URLs.urlToFile(url);
                return new GeoTiffReader(file, hints);
            }
            catch (DataSourceException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
        try {
            return new GeoTiffReader(source, hints);
        }
        catch (DataSourceException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    @Override
    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GeoTiffWriter(destination, hints);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    @Override
    public GridCoverageWriter getWriter(Object destination) {
        try {
            return new GeoTiffWriter(destination);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    @Override
    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return new GeoTiffWriteParams();
    }
}

