/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;

public final class OAuthUtils {
    private OAuthUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject getWithHeader(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Authorization", "Bearer " + StreetsideProperties.ACCESS_TOKEN.get());
        try (JsonReader reader = Json.createReader((Reader)new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8")));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
        catch (JsonException e) {
            throw new IOException(e);
        }
    }
}

