/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.history.commands;

import java.util.Set;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideCommand;
import org.openstreetmap.josm.tools.I18n;

public class CommandMove
extends StreetsideCommand {
    private double x;
    private double y;

    public CommandMove(Set<StreetsideAbstractImage> images, double x, double y) {
        super(images);
        this.x = x;
        this.y = y;
    }

    @Override
    public void undo() {
        for (StreetsideAbstractImage image : this.images) {
            image.move(-this.x, -this.y);
            image.stopMoving();
        }
        StreetsideLayer.invalidateInstance();
    }

    @Override
    public void redo() {
        for (StreetsideAbstractImage image : this.images) {
            image.move(this.x, this.y);
            image.stopMoving();
        }
        StreetsideLayer.invalidateInstance();
    }

    @Override
    public String toString() {
        return I18n.trn((String)"Moved {0} image", (String)"Moved {0} images", (long)this.images.size(), (Object[])new Object[]{this.images.size()});
    }

    @Override
    public void sum(StreetsideCommand command) {
        if (command instanceof CommandMove) {
            this.x += ((CommandMove)command).x;
            this.y += ((CommandMove)command).y;
        }
    }
}

