/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.history.commands;

import java.util.Arrays;
import java.util.concurrent.ConcurrentSkipListSet;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideCommand;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideExecutableCommand;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;
import org.openstreetmap.josm.tools.I18n;

public class CommandJoin
extends StreetsideExecutableCommand {
    private final StreetsideAbstractImage a;
    private final StreetsideAbstractImage b;

    public CommandJoin(StreetsideAbstractImage a, StreetsideAbstractImage b) {
        super(new ConcurrentSkipListSet<StreetsideAbstractImage>(Arrays.asList(a, b)));
        if (a.getSequence() == b.getSequence()) {
            throw new IllegalArgumentException("Both images must be in different sequences for joining.");
        }
        this.a = a;
        this.b = b;
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        StreetsideUtils.unjoin(this.a, this.b);
    }

    @Override
    public void redo() {
        StreetsideUtils.join(this.a, this.b);
    }

    @Override
    public void sum(StreetsideCommand command) {
    }

    @Override
    public String toString() {
        return I18n.tr((String)"2 images joined", (Object[])new Object[0]);
    }
}

