/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.history.commands;

import java.util.Set;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideCommand;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideExecutableCommand;
import org.openstreetmap.josm.tools.I18n;

public class CommandImport
extends StreetsideExecutableCommand {
    public CommandImport(Set<StreetsideAbstractImage> images) {
        super(images);
    }

    @Override
    public void execute() {
        StreetsideLayer.getInstance().getData().addAll(this.images);
    }

    @Override
    public void undo() {
        for (StreetsideAbstractImage img : this.images) {
            StreetsideLayer.getInstance().getData().getImages().remove(img);
        }
        StreetsideLayer.invalidateInstance();
    }

    @Override
    public void redo() {
        this.execute();
    }

    @Override
    public void sum(StreetsideCommand command) {
    }

    @Override
    public String toString() {
        return I18n.trn((String)"Imported {0} image", (String)"Imported {0} images", (long)this.images.size(), (Object[])new Object[]{this.images.size()});
    }
}

