/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ClipboardAction
extends AbstractAction {
    private static final long serialVersionUID = -7298944557860158010L;
    private static final long POPUP_DURATION = 3000L;
    private final JPopupMenu popup;
    private Component popupParent;
    private long lastPopupShowTime;
    private Transferable contents;

    public ClipboardAction(String name, Transferable contents) {
        super(name, ImageProvider.get((String)"copy", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SMALLICON));
        this.contents = contents;
        this.popup = new JPopupMenu();
        JLabel label = new JLabel(I18n.tr((String)"Key copied to clipboard", (Object[])new Object[0]) + '\u2026');
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.popup.add(label);
        this.popup.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        label.setForeground(Color.WHITE);
    }

    public void setContents(Transferable contents) {
        this.contents = contents;
        this.setEnabled(contents != null);
    }

    public void setPopupParent(Component popupParent) {
        this.popupParent = popupParent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.contents != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(this.contents, null);
            if (this.popupParent != null) {
                this.popup.show(this.popupParent, 0, this.popupParent.getHeight() + 2);
                new Thread(() -> {
                    block3: {
                        long threadStart;
                        this.lastPopupShowTime = threadStart = System.currentTimeMillis();
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e1) {
                            if (threadStart != this.lastPopupShowTime) break block3;
                            this.popup.setVisible(false);
                        }
                    }
                    if (System.currentTimeMillis() >= this.lastPopupShowTime + 3000L) {
                        this.popup.setVisible(false);
                    }
                }).start();
            }
        }
    }
}

