/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChooseGeoImageLayersDialog
extends JDialog {
    private static final long serialVersionUID = -1793622345412435234L;
    private static final String QUESTION = I18n.marktr((String)"Which image layers do you want to import into the Streetside layer?");

    public ChooseGeoImageLayersDialog(Component parent, List<GeoImageLayer> layers) {
        super(GuiHelper.getFrameForComponent((Component)parent), I18n.tr((String)QUESTION, (Object[])new Object[0]));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(10, 10));
        JPanel questionPanel = new JPanel(new FlowLayout(3, 10, 10));
        questionPanel.add(new JLabel(I18n.tr((String)QUESTION, (Object[])new Object[0])));
        c.add((Component)questionPanel, "North");
        JList<GeoImageLayer> list = new JList<GeoImageLayer>();
        list.setModel(new BasicListModel<GeoImageLayer>(layers));
        list.setCellRenderer(new GeoImageLayerListCellRenderer());
        list.setSelectionMode(2);
        c.add(list, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 10, 10));
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]), new ImageProvider("cancel").get());
        cancelButton.addActionListener(e -> this.dispose());
        cancelButton.requestFocus();
        buttonPanel.add(cancelButton);
        JButton importButton = new JButton(I18n.tr((String)"Import", (Object[])new Object[0]), new ImageProvider("copy").get());
        buttonPanel.add(importButton);
        c.add((Component)buttonPanel, "South");
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private static class BasicListModel<T>
    extends AbstractListModel<T> {
        private static final long serialVersionUID = 3107247955341855290L;
        private final List<T> list;

        public BasicListModel(List<T> list) {
            this.list = list == null ? new ArrayList() : list;
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public T getElementAt(int index) {
            return this.list.get(index);
        }
    }

    protected static class GeoImageLayerListCellRenderer
    implements ListCellRenderer<GeoImageLayer> {
        protected GeoImageLayerListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends GeoImageLayer> list, GeoImageLayer value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result;
            JLabel jLabel = result = value == null ? null : new JLabel(I18n.tr((String)"{0} ({1} images)", (Object[])new Object[]{value.getName(), value.getImages().size()}), value.getIcon(), 10);
            if (result != null) {
                result.setOpaque(true);
                result.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("List.background"));
            }
            return result;
        }
    }
}

