/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideCubemap;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.TileDownloadingTask;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideViewerDialog;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.StreetsideViewerPanel;
import org.openstreetmap.josm.plugins.streetside.utils.CubemapBox;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;

public class CubemapBuilder
implements ITileDownloadingTaskListener,
StreetsideDataListener {
    static final Logger logger = Logger.getLogger(CubemapBuilder.class);
    private static CubemapBuilder instance;
    private StreetsideCubemap cubemap;
    protected boolean cancelled;
    private long startTime;
    private Map<String, BufferedImage> tileImages = new HashMap<String, BufferedImage>();

    public Map<String, BufferedImage> getTileImages() {
        return this.tileImages;
    }

    public void setTileImages(Map<String, BufferedImage> tileImages) {
        this.tileImages = tileImages;
    }

    private CubemapBuilder() {
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        this.startTime = System.currentTimeMillis();
        if (newImage != null) {
            this.cubemap = null;
            this.cubemap = new StreetsideCubemap(newImage.getId(), newImage.getLatLon(), newImage.getHe());
            this.cubemap.setCd(newImage.getCd());
            this.downloadCubemapImages(this.cubemap.getId());
            long runTime = (System.currentTimeMillis() - this.startTime) / 1000L;
            logger.info(I18n.tr((String)"Completed downloading tiles for {0} in {1} seconds.", (Object[])new Object[]{newImage.getId(), runTime}));
        }
    }

    public void reload(String imageId) {
        if (this.cubemap != null && imageId.equals(this.cubemap.getId())) {
            this.tileImages = new HashMap<String, BufferedImage>();
            this.downloadCubemapImages(imageId);
        }
    }

    public void downloadCubemapImages(String imageId) {
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxThreadCount = 6 * maxCols * maxRows;
        int fails = 0;
        long startTime = System.currentTimeMillis();
        try {
            List results;
            ExecutorService pool = Executors.newFixedThreadPool(maxThreadCount);
            ArrayList<TileDownloadingTask> tasks = new ArrayList<TileDownloadingTask>(maxThreadCount);
            if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                for (int i = 0; i < 6; ++i) {
                    int tileNr = 0;
                    for (int j = 0; j < maxCols; ++j) {
                        for (int k = 0; k < maxRows; ++k) {
                            String tileId = String.valueOf(imageId + CubemapUtils.getFaceNumberForCount(i) + Integer.valueOf(tileNr++).toString());
                            tasks.add(new TileDownloadingTask(tileId));
                            logger.info(I18n.tr((String)"Starting tile downloading task for imageId {0}, cubeface {1}, tileNr {2}", (Object[])new Object[]{tileId, CubemapUtils.getFaceNumberForCount(i), String.valueOf(tileNr)}));
                        }
                    }
                }
                results = pool.invokeAll(tasks);
                for (Future ff : results) {
                    logger.debug(I18n.tr((String)"Completed tile downloading task {0} in {1}", (Object[])new Object[]{ff.get(), (startTime - System.currentTimeMillis()) / 1000L}));
                }
            } else if (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                for (int i = 0; i < 6; ++i) {
                    for (int j = 0; j < maxCols; ++j) {
                        for (int k = 0; k < maxRows; ++k) {
                            String tileId = String.valueOf(imageId + CubemapUtils.getFaceNumberForCount(i) + String.valueOf(Integer.valueOf(j).toString() + Integer.valueOf(k).toString()));
                            tasks.add(new TileDownloadingTask(tileId));
                            if (!StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) continue;
                            logger.debug(I18n.tr((String)"Starting tile downloading task for imageId {0}, cubeface {1}, tileID {2}", (Object[])new Object[]{imageId, CubemapUtils.getFaceNumberForCount(i), tileId}));
                        }
                    }
                }
                results = pool.invokeAll(tasks);
                for (Future ff : results) {
                    logger.debug(I18n.tr((String)"Completed tile downloading task {0} in {1}", (Object[])new Object[]{ff.get(), (startTime - System.currentTimeMillis()) / 1000L}));
                }
            }
        }
        catch (Exception ee) {
            ++fails;
            logger.error(I18n.tr((String)"Error loading tile for image {0}", (Object[])new Object[]{imageId}));
            ee.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        long runTime = stopTime - startTime;
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(I18n.tr((String)"Tile imagery downloading tasks completed in {0}", (Object[])new Object[]{runTime / 1000000L}));
        }
        if (fails > 0) {
            logger.error(I18n.tr((String)"{0} downloading tasks failed.", (Object[])new Object[]{fails}));
        }
    }

    @Override
    public void tileAdded(String tileId) {
        int maxRows;
        int tileCount = 0;
        tileCount = CubemapBuilder.getInstance().getTileImages().keySet().size();
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int n = maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        if (tileCount == 6 * maxCols * maxRows) {
            if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
                logger.debug(I18n.tr((String)"{0} tile images ready for building cumbemap faces for cubemap {0}", (Object[])new Object[]{tileCount, CubemapBuilder.getInstance().getCubemap().getId()}));
            }
            this.buildCubemapFaces();
        }
    }

    private void buildCubemapFaces() {
        int i;
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug("Assembling cubemap tile images");
        }
        CubemapBox cmb = StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().getCubemapBox();
        ImageView[] views = cmb.getViews();
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        Image[] finalImages = new Image[6];
        if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
            for (i = 0; i < 6; ++i) {
                BufferedImage[] faceTileImages = new BufferedImage[maxCols * maxRows];
                for (int j = 0; j < maxCols * maxRows; ++j) {
                    BufferedImage currentTile;
                    String tileId = String.valueOf(this.getCubemap().getId() + CubemapUtils.getFaceNumberForCount(i) + Integer.valueOf(j).toString());
                    faceTileImages[j] = currentTile = this.tileImages.get(tileId);
                }
                BufferedImage finalImg = GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
                if (i == 4) {
                    long start = System.nanoTime();
                    finalImg = GraphicsUtils.rotateImage(finalImg);
                    if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
                        logger.debug(I18n.tr((String)"Rotation took {0}", (Object[])new Object[]{System.nanoTime() - start}));
                    }
                }
                finalImages[i] = GraphicsUtils.convertBufferedImage2JavaFXImage(finalImg);
            }
        } else if (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
            for (i = 0; i < 6; ++i) {
                int tileCount = 0;
                BufferedImage[] faceTileImages = new BufferedImage[StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 16 : 4];
                for (int j = 0; j < maxCols; ++j) {
                    for (int k = 0; k < maxRows; ++k) {
                        String tileId = String.valueOf(this.getCubemap().getId() + CubemapUtils.getFaceNumberForCount(i) + CubemapUtils.convertDoubleCountNrto16TileNr(String.valueOf(Integer.valueOf(j).toString() + Integer.valueOf(k).toString())));
                        BufferedImage currentTile = this.tileImages.get(tileId);
                        faceTileImages[tileCount++] = currentTile;
                    }
                }
                BufferedImage finalImg = GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
                if (i == 4) {
                    finalImg = GraphicsUtils.rotateImage(finalImg);
                }
                finalImages[i] = GraphicsUtils.convertBufferedImage2JavaFXImage(finalImg);
            }
        }
        for (i = 0; i < 6; ++i) {
            views[i].setImage(finalImages[i]);
        }
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().revalidate();
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().repaint();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().setScene(StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().getCubemapScene());
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().revalidate();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().repaint();
        long endTime = System.currentTimeMillis();
        long runTime = (endTime - this.startTime) / 1000L;
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(I18n.tr((String)"Completed downloading, assembling and setting cubemap imagery for cubemap {0} in {1}", (Object[])new Object[]{this.cubemap.getId(), runTime}));
        }
        CubemapBuilder.getInstance().resetTileImages();
    }

    private void resetTileImages() {
        this.tileImages = new HashMap<String, BufferedImage>();
    }

    public synchronized StreetsideCubemap getCubemap() {
        return this.cubemap;
    }

    public static void setCubemap(StreetsideCubemap cubemap) {
        CubemapBuilder.getInstance().cubemap = cubemap;
    }

    public static CubemapBuilder getInstance() {
        if (instance == null) {
            instance = new CubemapBuilder();
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }
}

