/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.model.UserProfile;

public class StreetsideImage
extends StreetsideAbstractImage {
    private double la;
    private double lo;
    private double al;
    private double ro;
    private double pi;
    private String bl;
    private int ml;
    private List<String> nbn;
    private List<String> pbn;
    private int ad;
    private Rn rn;

    public StreetsideImage(String id, LatLon latLon, double he) {
        super(id, latLon, he);
    }

    public StreetsideImage(String id, LatLon latLon) {
        super(id, latLon, 0.0);
    }

    public StreetsideImage(String id, double la, double lo) {
        super(id, new LatLon(la, lo), 0.0);
    }

    public StreetsideImage(String id) {
        super(id);
    }

    public StreetsideImage() {
        super("00000000", null, 0.0);
    }

    @Override
    public String getId() {
        return String.valueOf(this.id);
    }

    public UserProfile getUser() {
        return this.getSequence().getUser();
    }

    public String toString() {
        return String.format("Image[id=%s,lat=%f,lon=%f,he=%f,user=%s]", this.id, this.latLon.lat(), this.latLon.lon(), this.he, "null");
    }

    public boolean equals(Object object) {
        return object instanceof StreetsideImage && this.id.equals(((StreetsideImage)object).getId());
    }

    @Override
    public int compareTo(StreetsideAbstractImage image) {
        if (image instanceof StreetsideImage) {
            return this.id.compareTo(((StreetsideImage)image).getId());
        }
        return this.hashCode() - image.hashCode();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void stopMoving() {
        super.stopMoving();
        this.checkModified();
    }

    private void checkModified() {
        if (StreetsideLayer.hasInstance()) {
            if (this.isModified()) {
                StreetsideLayer.getInstance().getLocationChangeset().add(this);
            } else {
                StreetsideLayer.getInstance().getLocationChangeset().remove(this);
            }
        }
    }

    @Override
    public void turn(double ca) {
        super.turn(ca);
        this.checkModified();
    }

    public double getAl() {
        return this.al;
    }

    public void setAl(double altitude) {
        this.al = altitude;
    }

    public double getRo() {
        return this.ro;
    }

    public void setRo(double roll) {
        this.ro = roll;
    }

    public double getPi() {
        return this.pi;
    }

    public void setPi(double pitch) {
        this.pi = pitch;
    }

    public String getBl() {
        return this.bl;
    }

    public void setBl(String blurring) {
        this.bl = blurring;
    }

    public int getMl() {
        return this.ml;
    }

    public void setMl(int ml) {
        this.ml = ml;
    }

    public List<String> getNbn() {
        return this.nbn;
    }

    public void setNbn(List<String> nbn) {
        this.nbn = nbn;
    }

    public List<String> getPbn() {
        return this.pbn;
    }

    public void setPbn(List<String> pbn) {
        this.pbn = pbn;
    }

    public int getAd() {
        return this.ad;
    }

    public void setAd(int ad) {
        this.ad = ad;
    }

    public double getLa() {
        return this.la;
    }

    public void setLa(double la) {
        this.la = la;
    }

    public double getLo() {
        return this.lo;
    }

    public void setLo(double lo) {
        this.lo = lo;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Rn getRn() {
        return this.rn;
    }

    public void setRn(Rn rn) {
        this.rn = rn;
    }

    public static class Rn {
    }
}

