/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;

public final class CoordinateFormatter {
    private static final double DECIMAL_MIN = Math.pow(10.0, -3.0);
    private static final double DECIMAL_MAX = Math.pow(10.0, 7.0);
    private final NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
    private final FieldPosition ZERO = new FieldPosition(0);
    private final double scale;
    private boolean forcedDecimal;

    public CoordinateFormatter(int numDecimals) {
        this.coordFormatter.setMaximumFractionDigits(numDecimals);
        this.coordFormatter.setGroupingUsed(false);
        this.scale = Math.pow(10.0, numDecimals);
    }

    public String format(double x) {
        StringBuffer sb = new StringBuffer();
        this.format(x, sb);
        return sb.toString();
    }

    public StringBuffer format(double x, StringBuffer sb) {
        if (Math.abs(x) >= DECIMAL_MIN && x < DECIMAL_MAX || x == 0.0) {
            long lx = (long)(x = this.truncate(x));
            if ((double)lx == x) {
                sb.append(lx);
            } else {
                sb.append(x);
            }
        } else if (this.forcedDecimal) {
            this.coordFormatter.format(x, sb, this.ZERO);
        } else {
            sb.append(this.truncate(x));
        }
        return sb;
    }

    final double truncate(double x) {
        double scaled = x * this.scale;
        scaled += 0.5;
        scaled = Math.floor(scaled);
        return scaled / this.scale;
    }

    public int getMaximumFractionDigits() {
        return this.coordFormatter.getMaximumFractionDigits();
    }

    public boolean isForcedDecimal() {
        return this.forcedDecimal;
    }

    public void setForcedDecimal(boolean forcedDecimal) {
        this.forcedDecimal = forcedDecimal;
    }
}

