/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.parsers;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;

public class Mapper {
    private final HashMap<String, String> mappings = new LinkedHashMap<String, String>();
    private final HashMap<String, Integer> mappingsWithIDs = new HashMap();
    private final Map<Integer, String> idsWithMappings = new HashMap<Integer, String>();

    public void parseFile(InputStream inps) throws FileNotFoundException {
        Scanner input = new Scanner(inps, "UTF-8");
        while (input.hasNext()) {
            String nextLine = input.nextLine();
            String[] splitContent = nextLine.split("\\|", 2);
            String key = splitContent[0];
            String value = splitContent[1];
            key = key.trim();
            value = value.trim();
            this.mappings.put(key, value);
        }
        this.constructMappingsWithIDs();
        this.constructIDsWithMappings();
        System.out.println("Mappings file parsed successfully!");
    }

    private void constructMappingsWithIDs() {
        Integer i = 1;
        for (String ontologyClass : this.mappings.values()) {
            this.mappingsWithIDs.put(ontologyClass, i);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public Map<String, Integer> getMappingsWithIDs() {
        return Collections.unmodifiableMap(this.mappingsWithIDs);
    }

    public Map<String, String> getMappings() {
        return Collections.unmodifiableMap(this.mappings);
    }

    private void constructIDsWithMappings() {
        int i = 1;
        for (String ontologyClass : this.mappings.values()) {
            this.idsWithMappings.put(i, ontologyClass);
            ++i;
        }
    }

    public Map<Integer, String> getIDsWithMappings() {
        return Collections.unmodifiableMap(this.idsWithMappings);
    }
}

