/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import javax.swing.JMenu;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.spi.preferences.Config;
import pdfimport.PdfImportAction;

public class PdfImportPlugin
extends Plugin {
    public PdfImportPlugin(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)MainApplication.getMenu().imagerySubMenu, (JosmAction)new PdfImportAction());
        Preferences.reload(this.getPluginInformation().name);
    }

    public static class Preferences {
        public static String LoadDir;
        public static GuiMode guiMode;
        public static boolean MergeNodes;
        public static double MergeNodesValue;
        public static boolean RemoveSmall;
        public static double RemoveSmallValue;
        public static boolean RemoveLarge;
        public static double RemoveLargeValue;
        public static boolean RemoveParallel;
        public static double RemoveParallelValue;
        public static boolean LimitPath;
        public static int LimitPathValue;
        public static boolean LimitColor;
        public static String LimitColorValue;
        public static boolean DebugTags;
        public static boolean LayerClosed;
        public static boolean LayerSegment;
        public static boolean LayerAttribChange;
        public static boolean LayerOrtho;
        protected static int GuiCode;
        private static String PreFix;

        private Preferences() {
        }

        public static void reload(String Name) {
            PreFix = Name + ".";
            LoadDir = Config.getPref().get(PreFix + "loadDir");
            GuiCode = Config.getPref().getInt(PreFix + "GuiCode", 0);
            switch (GuiCode) {
                case 1: {
                    guiMode = GuiMode.Expert;
                    break;
                }
                case 2: {
                    guiMode = GuiMode.Simple;
                    break;
                }
                default: {
                    guiMode = GuiMode.Expert;
                }
            }
            MergeNodes = Config.getPref().getBoolean(PreFix + "MergeNodes");
            MergeNodesValue = Config.getPref().getDouble(PreFix + "MergeNodes.Value", 0.001);
            RemoveSmall = Config.getPref().getBoolean(PreFix + "RemoveSmall");
            RemoveSmallValue = Config.getPref().getDouble(PreFix + "RemoveSmall.Value", 1.0);
            RemoveLarge = Config.getPref().getBoolean(PreFix + "RemoveLarge");
            RemoveLargeValue = Config.getPref().getDouble(PreFix + "RemoveLarge.Value", 10.0);
            RemoveParallel = Config.getPref().getBoolean(PreFix + "RemoveParallel");
            RemoveParallelValue = Config.getPref().getDouble(PreFix + "RemoveParalle.Value", 3.0);
            LimitPath = Config.getPref().getBoolean(PreFix + "LimitPath");
            LimitPathValue = Config.getPref().getInt(PreFix + "LimitPath.Value", 10000);
            LimitColor = Config.getPref().getBoolean(PreFix + "LimitColor");
            LimitColorValue = Config.getPref().get(PreFix + "LimitColor.Value", "#000000");
            DebugTags = Config.getPref().getBoolean(PreFix + "DebugTags");
            LayerClosed = Config.getPref().getBoolean(PreFix + "LayerClosed");
            LayerSegment = Config.getPref().getBoolean(PreFix + "LayerSegment");
            LayerAttribChange = Config.getPref().getBoolean(PreFix + "LayerAttribChanges");
            LayerOrtho = Config.getPref().getBoolean(PreFix + "LayerOrtho");
        }
    }

    public static enum GuiMode {
        Auto,
        Expert,
        Simple;

    }
}

