/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFMarkedContentExtractor;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoke
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        if (arguments.size() < 1) {
            return;
        }
        COSBase base0 = arguments.get(0);
        if (!(base0 instanceof COSName)) {
            return;
        }
        COSName name = (COSName)base0;
        Map<String, PDXObject> xobjects = this.context.getXObjects();
        PDXObject xobject = xobjects.get(name.getName());
        if (this.context instanceof PDFMarkedContentExtractor) {
            ((PDFMarkedContentExtractor)this.context).xobject(xobject);
        }
        if (xobject instanceof PDXObjectForm) {
            PDXObjectForm form = (PDXObjectForm)xobject;
            COSStream formContentstream = form.getCOSStream();
            Matrix matrix = form.getMatrix();
            if (matrix != null) {
                Matrix xobjectCTM = matrix.multiply(this.context.getGraphicsState().getCurrentTransformationMatrix());
                this.context.getGraphicsState().setCurrentTransformationMatrix(xobjectCTM);
            }
            PDResources pdResources = form.getResources();
            this.context.processSubStream(this.context.getCurrentPage(), pdResources, formContentstream);
        }
    }
}

