/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.measurement.MeasurementPlugin;
import org.openstreetmap.josm.tools.I18n;

public class MeasurementMode
extends MapMode {
    private static final long serialVersionUID = 3853830673475744263L;

    public MeasurementMode(String name, String desc) {
        super(name, "measurement.png", desc, Cursor.getPredefinedCursor(1));
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            MeasurementPlugin.getCurrentLayer().removeLastPoint();
        } else if (e.getButton() == 1) {
            LatLon coor = MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY());
            if (coor.isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Can not draw outside of the world.", (Object[])new Object[0]));
                return;
            }
            MeasurementPlugin.getCurrentLayer().mouseClicked(e);
        }
    }
}

