/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils.api;

import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.streetside.model.MapObject;
import org.openstreetmap.josm.plugins.streetside.utils.api.JsonDecoder;

public final class JsonMapObjectDecoder {
    private JsonMapObjectDecoder() {
    }

    public static MapObject decodeMapObject(JsonObject json) {
        if (json == null || !"Feature".equals(json.getString("type", null))) {
            return null;
        }
        JsonValue properties = (JsonValue)json.get((Object)"properties");
        JsonValue geometry = (JsonValue)json.get((Object)"geometry");
        if (properties instanceof JsonObject && geometry instanceof JsonObject) {
            LatLon coordinate;
            String key = ((JsonObject)properties).getString("key", null);
            String packg = ((JsonObject)properties).getString("package", null);
            String value = ((JsonObject)properties).getString("value", null);
            Long firstSeenTime = JsonDecoder.decodeTimestamp(((JsonObject)properties).getString("first_seen_at", null));
            Long lastSeenTime = JsonDecoder.decodeTimestamp(((JsonObject)properties).getString("last_seen_at", null));
            Long updatedTime = JsonDecoder.decodeTimestamp(((JsonObject)properties).getString("updated_at", null));
            JsonValue coordVal = "Point".equals(((JsonObject)geometry).getString("type", null)) ? (JsonValue)((JsonObject)geometry).get((Object)"coordinates") : null;
            LatLon latLon = coordinate = coordVal instanceof JsonArray ? JsonDecoder.decodeLatLon((JsonArray)coordVal) : null;
            if (key != null && packg != null && value != null && firstSeenTime != null && lastSeenTime != null && updatedTime != null && coordinate != null) {
                return new MapObject(coordinate, key, packg, value, firstSeenTime, lastSeenTime, updatedTime);
            }
        }
        return null;
    }
}

