/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class StreetsideURL {
    static final Logger logger = Logger.getLogger(StreetsideURL.class);
    private static final String STREETSIDE_BASE_URL = "https://dev.virtualearth.net/mapcontrol/HumanScaleServices/GetBubbles.ashx";
    private static final String CLIENT_ID = "T1Fzd20xZjdtR0s1VDk5OFNIOXpYdzoxNDYyOGRkYzUyYTFiMzgz";
    private static final String BING_MAPS_KEY = "AuftgJsO0Xs8Ts4M1xZUQJQXJNsvmh3IV8DkNieCiy3tCwCUMq76-WpkrBtNAuEm";
    private static final String TEST_BUBBLE_ID = "80848005";
    private static final String STREETSIDE_PRIVACY_URL = "https://www.bing.com/maps/privacyreport/streetsideprivacyreport?bubbleid=";
    private static final int OSM_BBOX_NORTH = 3;
    private static final int OSM_BBOX_SOUTH = 1;
    private static final int OSM_BBOXEAST = 2;
    private static final int OSM_BBOX_WEST = 0;

    private StreetsideURL() {
    }

    public static URL[] string2URLs(String baseUrlPrefix, String cubemapImageId, String baseUrlSuffix) {
        ArrayList res = new ArrayList();
        switch (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 16 : 4) {
            case 16: {
                EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> {
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            try {
                                String urlStr = baseUrlPrefix + cubemapImageId + CubemapUtils.rowCol2StreetsideCellAddressMap.get(String.valueOf(i) + String.valueOf(j)) + baseUrlSuffix;
                                res.add(new URL(urlStr));
                                continue;
                            }
                            catch (MalformedURLException e) {
                                logger.error(I18n.tr((String)"Error creating URL String for cubemap {0}", (Object[])new Object[]{cubemapImageId}));
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            case 4: {
                EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> {
                    for (int i = 0; i < 4; ++i) {
                        try {
                            String urlStr = baseUrlPrefix + cubemapImageId + CubemapUtils.rowCol2StreetsideCellAddressMap.get(String.valueOf(i)) + baseUrlSuffix;
                            res.add(new URL(urlStr));
                            continue;
                        }
                        catch (MalformedURLException e) {
                            logger.error(I18n.tr((String)"Error creating URL String for cubemap {0}", (Object[])new Object[]{cubemapImageId}));
                            e.printStackTrace();
                        }
                    }
                });
                break;
            }
        }
        return (URL[])res.stream().toArray(URL[]::new);
    }

    static String queryString(Map<String, String> parts) {
        StringBuilder ret = new StringBuilder("?client_id=").append(CLIENT_ID);
        if (parts != null) {
            for (Map.Entry<String, String> entry : parts.entrySet()) {
                try {
                    ret.append('&').append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name())).append('=').append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e);
                }
            }
        }
        logger.info(I18n.tr((String)"queryString result: {0}", (Object[])new Object[]{ret.toString()}));
        return ret.toString();
    }

    static String queryStreetsideBoundsString(Map<String, String> parts) {
        StringBuilder ret = new StringBuilder("?n=");
        if (parts != null) {
            ArrayList<String> bbox = new ArrayList<String>(Arrays.asList(parts.get("bbox").split(",")));
            try {
                ret.append(URLEncoder.encode((String)bbox.get(3), StandardCharsets.UTF_8.name())).append("&s=").append(URLEncoder.encode((String)bbox.get(1), StandardCharsets.UTF_8.name())).append("&e=").append(URLEncoder.encode((String)bbox.get(2), StandardCharsets.UTF_8.name())).append("&w=").append(URLEncoder.encode((String)bbox.get(0), StandardCharsets.UTF_8.name())).append("&c=1000").append("&appkey=").append(BING_MAPS_KEY);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e);
            }
        }
        logger.info(I18n.tr((String)"queryStreetsideBoundsString result: {0}", (Object[])new Object[]{ret.toString()}));
        return ret.toString();
    }

    static String queryByIdString(Map<String, String> parts) {
        StringBuilder ret = new StringBuilder("?id=");
        try {
            ret.append(URLEncoder.encode(TEST_BUBBLE_ID, StandardCharsets.UTF_8.name()));
            ret.append('&').append(URLEncoder.encode("appkey=", StandardCharsets.UTF_8.name())).append('=').append(URLEncoder.encode(BING_MAPS_KEY, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e);
        }
        logger.info(I18n.tr((String)"queryById result: {0}", (Object[])new Object[]{ret.toString()}));
        return ret.toString();
    }

    static URL string2URL(String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; strings != null && i < strings.length; ++i) {
            builder.append(strings[i]);
        }
        try {
            return new URL(builder.toString());
        }
        catch (MalformedURLException e) {
            logger.error(I18n.tr((String)String.format("The class '%s' produces malformed URLs like '%s'!", StreetsideURL.class.getName(), builder), (Object[])new Object[]{e}));
            return null;
        }
    }

    public static final class MainWebsite {
        private MainWebsite() {
        }

        public static URL browseImage(String id) {
            if (id == null) {
                throw new IllegalArgumentException("The image id may not be null!");
            }
            return StreetsideURL.string2URL("https://t.ssl.ak.tiles.virtualearth.net/tiles/hs" + id + ".jpg?g=6528&n=z");
        }

        public static URL streetsidePrivacyLink(String id) {
            String urlEncodedId;
            if (id == null) {
                throw new IllegalArgumentException("The image id must not be null!");
            }
            try {
                urlEncodedId = URLEncoder.encode(id, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                logger.error(I18n.tr((String)"Unsupported encoding when URL encoding", (Object[])new Object[]{e}));
                urlEncodedId = id;
            }
            return StreetsideURL.string2URL(StreetsideURL.STREETSIDE_PRIVACY_URL, urlEncodedId);
        }
    }

    public static final class VirtualEarth {
        private static final String BASE_URL_PREFIX = "https://t.ssl.ak.tiles.virtualearth.net/tiles/hs";
        private static final String BASE_URL_SUFFIX = ".jpg?g=6528&n=z";

        private VirtualEarth() {
        }

        public static URL streetsideTile(String id, boolean thumbnail) {
            int i;
            StringBuilder modifiedId = new StringBuilder();
            if (thumbnail) {
                if (id.length() < 16) {
                    for (i = 0; i < 16 - id.length(); ++i) {
                        modifiedId.append("0");
                    }
                }
                modifiedId.append(id).append("01");
            } else if (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                if (id.length() < 20) {
                    for (i = 0; i < 20 - id.length(); ++i) {
                        modifiedId.append("0");
                    }
                    modifiedId.append(id);
                }
            } else if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue() && id.length() < 19) {
                for (i = 0; i < 19 - id.length(); ++i) {
                    modifiedId.append("0");
                }
                modifiedId.append(id);
            }
            URL url = StreetsideURL.string2URL(BASE_URL_PREFIX + modifiedId.toString() + BASE_URL_SUFFIX);
            logger.info(I18n.tr((String)"Tile task URL {0} invoked.", (Object[])new Object[]{url.toString()}));
            return url;
        }
    }

    public static final class APIv3 {
        private APIv3() {
        }

        public static URL searchStreetsideImages(Bounds bounds) {
            return StreetsideURL.string2URL(StreetsideURL.STREETSIDE_BASE_URL, APIv3.queryStreetsideString(bounds));
        }

        public static URL searchStreetsideSequences(Bounds bounds) {
            return StreetsideURL.string2URL(StreetsideURL.STREETSIDE_BASE_URL, APIv3.queryStreetsideString(bounds));
        }

        public static URL parseNextFromLinkHeaderValue(String value) {
            if (value != null) {
                for (String link : value.split(",", Integer.MAX_VALUE)) {
                    boolean isNext = false;
                    URL url = null;
                    for (String linkPart : link.split(";", Integer.MAX_VALUE)) {
                        linkPart = linkPart.trim();
                        isNext |= linkPart.matches("rel\\s*=\\s*\"next\"");
                        if (linkPart.length() < 1 || linkPart.charAt(0) != '<' || !linkPart.endsWith(">")) continue;
                        try {
                            url = new URL(linkPart.substring(1, linkPart.length() - 1));
                        }
                        catch (MalformedURLException e) {
                            Logging.log((Level)Logging.LEVEL_WARN, (String)"Mapillary API v3 returns a malformed URL in the Link header.", (Throwable)e);
                        }
                    }
                    if (url == null || !isNext) continue;
                    return url;
                }
            }
            return null;
        }

        public static String queryString(Bounds bounds) {
            if (bounds != null) {
                HashMap<String, String> parts = new HashMap<String, String>();
                parts.put("bbox", bounds.toBBox().toStringCSV(","));
                return StreetsideURL.queryString(parts);
            }
            return StreetsideURL.queryString(null);
        }

        public static String queryStreetsideString(Bounds bounds) {
            if (bounds != null) {
                HashMap<String, String> parts = new HashMap<String, String>();
                parts.put("bbox", bounds.toBBox().toStringCSV(","));
                return StreetsideURL.queryStreetsideBoundsString(parts);
            }
            return StreetsideURL.queryStreetsideBoundsString(null);
        }
    }
}

