/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.history.commands;

import java.util.Set;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.history.commands.StreetsideCommand;
import org.openstreetmap.josm.tools.I18n;

public class CommandTurn
extends StreetsideCommand {
    private double ca;

    public CommandTurn(Set<StreetsideAbstractImage> images, double ca) {
        super(images);
        this.ca = ca;
    }

    @Override
    public void undo() {
        for (StreetsideAbstractImage image : this.images) {
            image.turn(-this.ca);
            image.stopMoving();
        }
        StreetsideLayer.invalidateInstance();
    }

    @Override
    public void redo() {
        for (StreetsideAbstractImage image : this.images) {
            image.turn(this.ca);
            image.stopMoving();
        }
        StreetsideLayer.invalidateInstance();
    }

    @Override
    public String toString() {
        return I18n.trn((String)"Turned {0} image", (String)"Turned {0} images", (long)this.images.size(), (Object[])new Object[]{this.images.size()});
    }

    @Override
    public void sum(StreetsideCommand command) {
        if (command instanceof CommandTurn) {
            this.ca += ((CommandTurn)command).ca;
        }
    }
}

