/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class WebLinkAction
extends AbstractAction {
    private static final long serialVersionUID = -8168227661356480455L;
    static final Logger logger = Logger.getLogger(WebLinkAction.class);
    private URL url;

    public WebLinkAction(String name, URL url) {
        super(name, ImageProvider.get((String)"link", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SMALLICON));
        this.setURL(url);
    }

    public final void setURL(URL url) {
        this.url = url;
        this.setEnabled(url != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StreetsideUtils.browse(this.url);
        }
        catch (IOException e1) {
            String msg = I18n.tr((String)"Could not open the URL {0} in a browser", (Object[])new Object[]{this.url == null ? "\u2039null\u203a" : this.url});
            logger.warn(msg, e1);
            new Notification(msg).setIcon(2).show();
        }
    }
}

