/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.SelectableLabel;
import org.openstreetmap.josm.plugins.streetside.gui.boilerplate.StreetsideButton;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ClipboardAction;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.WebLinkAction;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.I18n;

public final class ImageInfoPanel
extends ToggleDialog
implements StreetsideDataListener,
DataSelectionListener {
    private static final long serialVersionUID = 4141847503072417190L;
    static final Logger logger = Logger.getLogger(ImageInfoPanel.class);
    private static ImageInfoPanel instance;
    private static final ImageIcon EMPTY_USER_AVATAR;
    private final JLabel numDetectionsLabel;
    private final JLabel placeholder1Label;
    private final JLabel usernameLabel;
    private final JTextPane imgKeyValue;
    private final WebLinkAction imgLinkAction;
    private final ClipboardAction copyImgKeyAction;
    private final JTextPane seqKeyValue;
    private AbstractProperty.ValueChangeListener<Boolean> imageLinkChangeListener;

    private ImageInfoPanel() {
        super(I18n.tr((String)"Streetside Image info", (Object[])new Object[0]), "streetside-info", I18n.tr((String)"Displays detail information on the currently selected Streetside image", (Object[])new Object[0]), null, 150);
        SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
        this.numDetectionsLabel = new JLabel();
        this.numDetectionsLabel.setFont(this.numDetectionsLabel.getFont().deriveFont(0));
        this.placeholder1Label = new JLabel();
        this.usernameLabel = new JLabel();
        this.usernameLabel.setFont(this.usernameLabel.getFont().deriveFont(0));
        this.imgKeyValue = new SelectableLabel();
        this.imgLinkAction = new WebLinkAction(I18n.tr((String)"View in browser", (Object[])new Object[0]), null);
        this.copyImgKeyAction = new ClipboardAction(I18n.tr((String)"Copy key", (Object[])new Object[0]), null);
        StreetsideButton copyButton = new StreetsideButton(this.copyImgKeyAction, true);
        this.copyImgKeyAction.setPopupParent(copyButton);
        JPanel imgKey = new JPanel();
        imgKey.add(this.imgKeyValue);
        imgKey.add(copyButton);
        JPanel imgButtons = new JPanel();
        imgButtons.add(new StreetsideButton(this.imgLinkAction, true));
        this.seqKeyValue = new SelectableLabel();
        JPanel root = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 22;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        root.add((Component)new JLabel(I18n.tr((String)"Placeholder2 label", (Object[])new Object[0])), gbc);
        gbc.gridy += 2;
        gbc.gridheight = 1;
        root.add((Component)new JLabel(I18n.tr((String)"Blah", (Object[])new Object[0])), gbc);
        ++gbc.gridy;
        root.add((Component)new JLabel(I18n.tr((String)"Blee", (Object[])new Object[0])), gbc);
        ++gbc.gridy;
        root.add((Component)new JLabel(I18n.tr((String)"Image key", (Object[])new Object[0])), gbc);
        ++gbc.gridy;
        root.add((Component)new JLabel(I18n.tr((String)"Sequence key", (Object[])new Object[0])), gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.anchor = 21;
        root.add((Component)this.numDetectionsLabel, gbc);
        ++gbc.gridy;
        root.add((Component)this.placeholder1Label, gbc);
        ++gbc.gridy;
        root.add((Component)this.usernameLabel, gbc);
        ++gbc.gridy;
        root.add((Component)imgButtons, gbc);
        ++gbc.gridy;
        root.add((Component)imgKey, gbc);
        ++gbc.gridy;
        root.add((Component)this.seqKeyValue, gbc);
        this.createLayout(root, true, null);
        this.selectedImageChanged(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfoPanel getInstance() {
        Class<ImageInfoPanel> clazz = ImageInfoPanel.class;
        synchronized (ImageInfoPanel.class) {
            if (instance == null) {
                instance = new ImageInfoPanel();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    protected void stateChanged() {
        super.stateChanged();
        if (this.isDialogShowing()) {
            StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.put(Integer.valueOf(0));
        }
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public synchronized void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        String newImageKey;
        logger.info(String.format("Selected Streetside image changed from %s to %s.", oldImage instanceof StreetsideImage ? ((StreetsideImage)oldImage).getId() : "\u2039none\u203a", newImage instanceof StreetsideImage ? ((StreetsideImage)newImage).getId() : "\u2039none\u203a"));
        this.imgKeyValue.setEnabled(newImage instanceof StreetsideImage);
        String string = newImageKey = newImage instanceof StreetsideImage ? ((StreetsideImage)newImage).getId() : null;
        if (newImageKey != null) {
            this.imageLinkChangeListener = b -> this.imgLinkAction.setURL(StreetsideURL.MainWebsite.browseImage(newImageKey));
            this.imageLinkChangeListener.valueChanged(null);
            StreetsideProperties.IMAGE_LINK_TO_BLUR_EDITOR.addListener(this.imageLinkChangeListener);
            this.imgKeyValue.setText(newImageKey);
            this.copyImgKeyAction.setContents(new StringSelection(newImageKey));
        } else {
            if (this.imageLinkChangeListener != null) {
                StreetsideProperties.IMAGE_LINK_TO_BLUR_EDITOR.removeListener(this.imageLinkChangeListener);
                this.imageLinkChangeListener = null;
            }
            this.imgLinkAction.setURL(null);
            this.imgKeyValue.setText('\u2039' + I18n.tr((String)"image has no key", (Object[])new Object[0]) + '\u203a');
            this.copyImgKeyAction.setContents(null);
        }
        boolean partOfSequence = newImage != null && newImage.getSequence() != null && newImage.getSequence().getId() != null;
        this.seqKeyValue.setEnabled(partOfSequence);
        if (partOfSequence) {
            this.seqKeyValue.setText(newImage.getSequence().getId());
        } else {
            this.seqKeyValue.setText('\u2039' + I18n.tr((String)"sequence has no id", (Object[])new Object[0]) + '\u203a');
        }
    }

    public synchronized void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        Set sel = event.getSelection();
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(String.format("Selection changed. %d primitives are selected.", sel == null ? 0 : sel.size()));
        }
    }

    static {
        EMPTY_USER_AVATAR = new ImageIcon(new BufferedImage(32, 32, 2));
    }
}

