/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImportedImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.actions.WalkListener;
import org.openstreetmap.josm.plugins.streetside.actions.WalkThread;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideImageDisplay;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsidePreferenceSetting;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ImageInfoHelpPopup;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.StreetsideViewerHelpPopup;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class StreetsideMainDialog
extends ToggleDialog
implements ICachedLoaderListener,
StreetsideDataListener {
    private static final long serialVersionUID = 2645654786827812861L;
    static final Logger logger = Logger.getLogger(StreetsideMainDialog.class);
    public static final String BASE_TITLE = I18n.marktr((String)"Microsoft Streetside image");
    private static final String MESSAGE_SEPARATOR = " \u2014 ";
    private static StreetsideMainDialog instance;
    private volatile StreetsideAbstractImage image;
    public final SideButton nextButton = new SideButton((Action)new NextPictureAction());
    public final SideButton previousButton = new SideButton((Action)new PreviousPictureAction());
    public final SideButton redButton = new SideButton((Action)new RedAction());
    public final SideButton blueButton = new SideButton((Action)new BlueAction());
    private final SideButton playButton = new SideButton((Action)new PlayAction());
    private final SideButton pauseButton = new SideButton((Action)new PauseAction());
    private final SideButton stopButton = new SideButton((Action)new StopAction());
    private ImageInfoHelpPopup imageInfoHelp;
    private StreetsideViewerHelpPopup streetsideViewerHelp;
    public StreetsideImageDisplay streetsideImageDisplay;
    private StreetsideCache imageCache;
    public StreetsideCache thumbnailCache;

    private StreetsideMainDialog() {
        super(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]), "streetside-main", I18n.tr((String)"Open Streetside window", (Object[])new Object[0]), null, 200, true, StreetsidePreferenceSetting.class);
        this.addShortcuts();
        this.streetsideImageDisplay = new StreetsideImageDisplay();
        this.blueButton.setForeground(Color.BLUE);
        this.redButton.setForeground(Color.RED);
        this.setMode(MODE.NORMAL);
    }

    private void addShortcuts() {
        this.nextButton.getInputMap(2).put(KeyStroke.getKeyStroke("PAGE_DOWN"), "next");
        this.nextButton.getActionMap().put("next", new NextPictureAction());
        this.previousButton.getInputMap(2).put(KeyStroke.getKeyStroke("PAGE_UP"), "previous");
        this.previousButton.getActionMap().put("previous", new PreviousPictureAction());
        this.blueButton.getInputMap(2).put(KeyStroke.getKeyStroke("control PAGE_UP"), "blue");
        this.blueButton.getActionMap().put("blue", new BlueAction());
        this.redButton.getInputMap(2).put(KeyStroke.getKeyStroke("control PAGE_DOWN"), "red");
        this.redButton.getActionMap().put("red", new RedAction());
    }

    public static synchronized StreetsideMainDialog getInstance() {
        if (instance == null) {
            instance = new StreetsideMainDialog();
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public synchronized void setImageInfoHelp(ImageInfoHelpPopup popup) {
        this.imageInfoHelp = popup;
    }

    public synchronized void setStreetsideViewerHelp(StreetsideViewerHelpPopup popup) {
        this.streetsideViewerHelp = popup;
    }

    public StreetsideViewerHelpPopup getStreetsideViewerHelp() {
        return this.streetsideViewerHelp;
    }

    public void setMode(MODE mode) {
        switch (mode) {
            case WALK: {
                this.createLayout(this.streetsideImageDisplay, Arrays.asList(this.playButton, this.pauseButton, this.stopButton));
            }
        }
        this.createLayout(this.streetsideImageDisplay, Arrays.asList(this.blueButton, this.previousButton, this.nextButton, this.redButton));
        this.disableAllButtons();
        if (MODE.NORMAL.equals((Object)mode)) {
            this.updateImage();
        }
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    public synchronized void updateImage() {
        this.updateImage(true);
    }

    public synchronized void updateImage(boolean fullQuality) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateImage);
        } else {
            StreetsideAbstractImage tempImage;
            if (!StreetsideLayer.hasInstance()) {
                return;
            }
            if (this.image == null) {
                this.streetsideImageDisplay.setImage(null, null);
                this.setTitle(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]));
                this.disableAllButtons();
                return;
            }
            if (this.imageInfoHelp != null && StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.get() > 0 && this.imageInfoHelp.showPopup()) {
                StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.put(Integer.valueOf(StreetsideProperties.IMAGEINFO_HELP_COUNTDOWN.get() - 1));
            }
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
            if (this.image.getSequence() != null) {
                tempImage = this.image;
                while (tempImage.next() != null) {
                    if (!(tempImage = tempImage.next()).isVisible()) continue;
                    this.nextButton.setEnabled(true);
                    break;
                }
            }
            if (this.image.getSequence() != null) {
                tempImage = this.image;
                while (tempImage.previous() != null) {
                    if (!(tempImage = tempImage.previous()).isVisible()) continue;
                    this.previousButton.setEnabled(true);
                    break;
                }
            }
            if (this.image instanceof StreetsideImage) {
                StreetsideImage streetsideImage = (StreetsideImage)this.image;
                this.streetsideImageDisplay.setImage(null, null);
                if (this.thumbnailCache != null) {
                    this.thumbnailCache.cancelOutstandingTasks();
                }
                this.thumbnailCache = new StreetsideCache(streetsideImage.getId(), StreetsideCache.Type.THUMBNAIL);
                try {
                    this.thumbnailCache.submit(this, false);
                }
                catch (IOException e) {
                    logger.error(e);
                }
                if (fullQuality || new StreetsideCache(streetsideImage.getId(), StreetsideCache.Type.FULL_IMAGE).get() != null) {
                    if (this.imageCache != null) {
                        this.imageCache.cancelOutstandingTasks();
                    }
                    this.imageCache = new StreetsideCache(streetsideImage.getId(), StreetsideCache.Type.FULL_IMAGE);
                    try {
                        this.imageCache.submit(this, false);
                    }
                    catch (IOException e) {
                        logger.error(e);
                    }
                }
            }
            this.updateTitle();
        }
    }

    public void disableAllButtons() {
        this.nextButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.blueButton.setEnabled(false);
        this.redButton.setEnabled(false);
    }

    public synchronized void setImage(StreetsideAbstractImage image) {
        this.image = image;
    }

    public synchronized void updateTitle() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateTitle);
        } else if (this.image != null) {
            StringBuilder title = new StringBuilder(I18n.tr((String)BASE_TITLE, (Object[])new Object[0]));
            if (this.image instanceof StreetsideImage) {
                StreetsideImage streetsideImage = (StreetsideImage)this.image;
                if (streetsideImage.getCd() != 0L) {
                    title.append(MESSAGE_SEPARATOR).append(streetsideImage.getDate());
                }
                this.setTitle(title.toString());
            } else if (this.image instanceof StreetsideImportedImage) {
                StreetsideImportedImage mapillaryImportedImage = (StreetsideImportedImage)this.image;
                title.append(MESSAGE_SEPARATOR).append(mapillaryImportedImage.getFile().getName());
                title.append(MESSAGE_SEPARATOR).append(mapillaryImportedImage.getDate());
                this.setTitle(title.toString());
            }
        }
    }

    public synchronized StreetsideAbstractImage getImage() {
        return this.image;
    }

    public void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.loadingFinished(data, attributes, result));
        } else if (data != null && result == ICachedLoaderListener.LoadResult.SUCCESS) {
            try {
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(data.getContent()));
                if (img == null) {
                    return;
                }
                if (this.streetsideImageDisplay.getImage() == null || img.getHeight() > this.streetsideImageDisplay.getImage().getHeight()) {
                    this.streetsideImageDisplay.setImage(img, null);
                }
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
    }

    public void createLayout(Component data, List<SideButton> buttons) {
        this.removeAll();
        this.createLayout(data, true, buttons);
        this.add((Component)this.titleBar, "North");
    }

    @Override
    public void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        this.setImage(newImage);
        this.updateImage();
    }

    @Override
    public void imagesAdded() {
    }

    public StreetsideImageDisplay getStreetsideImageDisplay() {
        return this.streetsideImageDisplay;
    }

    public void setStreetsideImageDisplay(StreetsideImageDisplay streetsideImageDisplay) {
        this.streetsideImageDisplay = streetsideImageDisplay;
    }

    private static class PauseAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = -8758326399460817222L;
        private WalkThread thread;

        PauseAction() {
            this.putValue("Name", I18n.tr((String)"Pause", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Pauses the walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/streetsidePause.png").getResource().attachImageIcon((AbstractAction)this, true);
            StreetsidePlugin.getStreetsideWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.thread.pause();
        }

        @Override
        public void walkStarted(WalkThread thread) {
            this.thread = thread;
        }
    }

    private static class PlayAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = -1572747020946842769L;
        private transient WalkThread thread;

        PlayAction() {
            this.putValue("Name", I18n.tr((String)"Play", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Continues with the paused walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/streetsidePlay.png").getResource().attachImageIcon((AbstractAction)this, true);
            StreetsidePlugin.getStreetsideWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.thread != null) {
                this.thread.play();
            }
        }

        @Override
        public void walkStarted(WalkThread thread) {
            if (thread != null) {
                this.thread = thread;
            }
        }
    }

    private static class StopAction
    extends AbstractAction
    implements WalkListener {
        private static final long serialVersionUID = 8789972456611625341L;
        private WalkThread thread;

        StopAction() {
            this.putValue("Name", I18n.tr((String)"Stop", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Stops the walk.", (Object[])new Object[0]));
            new ImageProvider("dialogs/streetsideStop.png").getResource().attachImageIcon((AbstractAction)this, true);
            StreetsidePlugin.getStreetsideWalkAction().addListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.thread != null) {
                this.thread.stopWalk();
            }
        }

        @Override
        public void walkStarted(WalkThread thread) {
            this.thread = thread;
        }
    }

    private static class BlueAction
    extends AbstractAction {
        private static final long serialVersionUID = 5951233534212838780L;

        BlueAction() {
            this.putValue("Name", I18n.tr((String)"Jump to blue", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the picture at the other side of the blue line", (Object[])new Object[0]));
            new ImageProvider("dialogs", "blue").getResource().attachImageIcon((AbstractAction)this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StreetsideMainDialog.getInstance().getImage() != null) {
                StreetsideLayer.getInstance().getData().setSelectedImage(StreetsideLayer.getInstance().getNNearestImage(2), true);
            }
        }
    }

    private static class RedAction
    extends AbstractAction {
        private static final long serialVersionUID = -1244456062285831231L;

        RedAction() {
            this.putValue("Name", I18n.tr((String)"Jump to red", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Jumps to the picture at the other side of the red line", (Object[])new Object[0]));
            new ImageProvider("dialogs", "red").getResource().attachImageIcon((AbstractAction)this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StreetsideMainDialog.getInstance().getImage() != null) {
                StreetsideLayer.getInstance().getData().setSelectedImage(StreetsideLayer.getInstance().getNNearestImage(1), true);
            }
        }
    }

    private static class PreviousPictureAction
    extends AbstractAction {
        private static final long serialVersionUID = 4390593660514657107L;

        PreviousPictureAction() {
            super(I18n.tr((String)"Previous picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the previous picture in the sequence", (Object[])new Object[0]));
            new ImageProvider("help", "previous").getResource().attachImageIcon((AbstractAction)this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StreetsideLayer.getInstance().getData().selectPrevious();
        }
    }

    private static class NextPictureAction
    extends AbstractAction {
        private static final long serialVersionUID = 6333692154558730392L;

        NextPictureAction() {
            super(I18n.tr((String)"Next picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the next picture in the sequence", (Object[])new Object[0]));
            new ImageProvider("help", "next").getResource().attachImageIcon((AbstractAction)this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StreetsideLayer.getInstance().getData().selectNext();
        }
    }

    public static enum MODE {
        NORMAL,
        WALK;

    }
}

